/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.mixin;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PiglinTasks.class})
public class MixinPiglinTasks {
    private static final String AVARICE_SCROLL_TAG = "enigmaticlegacy:avarice_scroll_effect";

    private static void markPiglinWithCondition(PiglinEntity piglin, PlayerEntity player) {
        if (player != null && piglin != null && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.avariceScroll) && !piglin.func_184216_O().contains(AVARICE_SCROLL_TAG)) {
            piglin.func_184211_a(AVARICE_SCROLL_TAG);
        }
    }

    private static List<ItemStack> distributeExcess(ItemStack stack) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        while (stack.func_190916_E() > stack.func_77976_d()) {
            newStacks.add(stack.func_77979_a(stack.func_77976_d()));
        }
        return newStacks;
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234470_a_"})
    private static void onPiglinItemPickup(PiglinEntity piglin, ItemEntity itemEntity, CallbackInfo info) {
        UUID ownerID = itemEntity.func_200214_m();
        if (!itemEntity.func_70089_S() && itemEntity.field_70170_p instanceof ServerWorld && ownerID != null) {
            ServerWorld world = (ServerWorld)itemEntity.field_70170_p;
            MixinPiglinTasks.markPiglinWithCondition(piglin, world.func_217371_b(ownerID));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"func_234471_a_"})
    private static void onBarterByHand(PiglinEntity piglin, PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
        if (info.getReturnValue() == ActionResultType.CONSUME) {
            MixinPiglinTasks.markPiglinWithCondition(piglin, player);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"func_234477_a_"}, cancellable=true)
    private static void onPiglinBarter(PiglinEntity piglin, boolean repay, CallbackInfo info) {
        ItemStack stack = piglin.func_184586_b(Hand.OFF_HAND);
        if (piglin.field_70170_p instanceof ServerWorld && piglin.func_184216_O().contains(AVARICE_SCROLL_TAG)) {
            piglin.func_184197_b(AVARICE_SCROLL_TAG);
            if (piglin.func_242337_eM() && repay && stack.isPiglinCurrency()) {
                info.cancel();
                piglin.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
                List generatedLoot = PiglinTasks.func_234524_k_((PiglinEntity)piglin);
                ArrayList newStacks = new ArrayList();
                generatedLoot.forEach(lootStack -> {
                    if (lootStack != null && !lootStack.func_190926_b()) {
                        double multiplier = EnigmaticEventHandler.theySeeMeRollin.nextDouble() * 2.0;
                        int bonusAmount = (int)Math.round((double)lootStack.func_190916_E() * multiplier);
                        int newCount = lootStack.func_190916_E() + bonusAmount;
                        lootStack.func_190920_e(newCount);
                        newStacks.addAll(MixinPiglinTasks.distributeExcess(lootStack));
                    }
                });
                generatedLoot.addAll(newStacks);
                PiglinTasks.func_234475_a_((PiglinEntity)piglin, (List)generatedLoot);
            }
        }
    }
}

