/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.objects;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.items.MagmaHeart;
import com.integral.enigmaticlegacy.packets.clients.PacketSyncTransientData;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class TransientPlayerData {
    private final PlayerEntity player;
    private int fireImmunityTimer;
    private int fireImmunityTimerCap;
    public int spellstoneCooldown;
    private int fireImmunityTimerLast;
    private Boolean consumedForbiddenFruit;
    public boolean needsSync = false;

    public static TransientPlayerData get(PlayerEntity player) {
        boolean clientOnly = player.field_70170_p.field_72995_K;
        if (EnigmaticLegacy.proxy.getTransientPlayerData(clientOnly).containsKey(player)) {
            return EnigmaticLegacy.proxy.getTransientPlayerData(clientOnly).get(player);
        }
        TransientPlayerData data = new TransientPlayerData(player);
        EnigmaticLegacy.proxy.getTransientPlayerData(clientOnly).put(player, data);
        return data;
    }

    public static boolean set(PlayerEntity player, TransientPlayerData data) {
        boolean clientOnly = player.field_70170_p.field_72995_K;
        if (data != null) {
            EnigmaticLegacy.proxy.getTransientPlayerData(clientOnly).put(player, data);
            return true;
        }
        return false;
    }

    public void syncToClients(float blockRadius) {
        PlayerEntity player = this.getPlayer();
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (double)blockRadius, player.field_70170_p.func_234923_W_())), (Object)new PacketSyncTransientData(this));
    }

    public void syncToPlayer() {
        if (this.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.getPlayer();
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketSyncTransientData(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void syncToServer() {
    }

    public TransientPlayerData(PlayerEntity thePlayer) {
        this.player = thePlayer;
        this.fireImmunityTimer = 0;
        this.spellstoneCooldown = 0;
        this.fireImmunityTimerLast = 0;
        this.fireImmunityTimerCap = 30000 + this.getFireDiff();
    }

    public int getFireDiff() {
        return 2000;
    }

    public int getFireImmunityTimerLast() {
        return this.fireImmunityTimerLast;
    }

    public void setFireImmunityTimerLast(int fireImmunityTimerLast) {
        this.fireImmunityTimerLast = fireImmunityTimerLast;
    }

    public int getFireImmunityTimerCap() {
        return this.fireImmunityTimerCap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFireImmunityFraction(float partialTick) {
        float difference = (float)this.fireImmunityTimer - (float)this.fireImmunityTimerLast;
        double coolFiller = MagmaHeart.traitorBar.getValue() ? SuperpositionHandler.parabolicFunction(0.0, this.fireImmunityTimerCap - this.getFireDiff(), (double)this.fireImmunityTimerLast + (double)difference) : SuperpositionHandler.flippedParabolicFunction(0.0, this.fireImmunityTimerCap - this.getFireDiff(), (double)this.fireImmunityTimerLast + (double)(difference *= 0.0f));
        return (float)coolFiller;
    }

    public int getFireImmunityTimer() {
        return this.fireImmunityTimer;
    }

    public int getSpellstoneCooldown() {
        return this.spellstoneCooldown;
    }

    public void setFireImmunityTimer(int fireImmunityTimer) {
        int newValue = Math.min(Math.max(fireImmunityTimer, 0), this.fireImmunityTimerCap);
        if (newValue != this.fireImmunityTimer) {
            this.needsSync = true;
        }
        this.fireImmunityTimerLast = fireImmunityTimer;
        this.fireImmunityTimer = newValue;
    }

    public void setSpellstoneCooldown(int spellstoneCooldown) {
        int newValue = Math.max(spellstoneCooldown, 0);
        if (this.spellstoneCooldown != newValue) {
            this.needsSync = true;
            this.spellstoneCooldown = newValue;
            for (Item spellstone : EnigmaticLegacy.spellstoneList) {
                this.player.func_184811_cZ().func_185145_a(spellstone, this.spellstoneCooldown);
            }
        }
    }

    public Boolean getConsumedForbiddenFruit() {
        return this.consumedForbiddenFruit != null ? this.consumedForbiddenFruit : (this.consumedForbiddenFruit = Boolean.valueOf(SuperpositionHandler.getPersistentBoolean(this.player, "ConsumedForbiddenFruit", false)));
    }

    public void setConsumedForbiddenFruit(Boolean consumedForbiddenFruit) {
        this.consumedForbiddenFruit = consumedForbiddenFruit;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public static PacketBuffer encode(TransientPlayerData data, PacketBuffer buf) {
        buf.func_179252_a(data.player.func_110124_au());
        buf.writeInt(data.spellstoneCooldown);
        buf.writeInt(data.fireImmunityTimer);
        buf.writeInt(data.fireImmunityTimerCap);
        buf.writeInt(data.fireImmunityTimerLast);
        buf.writeBoolean(data.getConsumedForbiddenFruit().booleanValue());
        return buf;
    }

    public static TransientPlayerData decode(PacketBuffer buf) {
        UUID playerID = buf.func_179253_g();
        int spellstoneCooldown = buf.readInt();
        int fireImmunityTimer = buf.readInt();
        int fireImmunityTimerCap = buf.readInt();
        int fireImmunityTimerLast = buf.readInt();
        boolean consumedForbiddenFruit = buf.readBoolean();
        PlayerEntity player = EnigmaticLegacy.proxy.getPlayer(playerID);
        if (player != null) {
            TransientPlayerData data = new TransientPlayerData(player);
            data.spellstoneCooldown = spellstoneCooldown;
            data.fireImmunityTimer = fireImmunityTimer;
            data.fireImmunityTimerCap = fireImmunityTimerCap;
            data.fireImmunityTimerLast = fireImmunityTimerLast;
            data.consumedForbiddenFruit = consumedForbiddenFruit;
            return data;
        }
        return null;
    }
}

