/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.packets.clients;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.objects.Vector3;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGenericParticleEffect {
    private Vector3 pos;
    private int num;
    private boolean check;
    private Effect effect;

    public PacketGenericParticleEffect(double x, double y, double z, int number, boolean checkSettings, Effect effect) {
        this.pos = new Vector3(x, y, z);
        this.num = number;
        this.check = checkSettings;
        this.effect = effect;
    }

    public static void encode(PacketGenericParticleEffect msg, PacketBuffer buf) {
        buf.writeDouble(msg.pos.x);
        buf.writeDouble(msg.pos.y);
        buf.writeDouble(msg.pos.z);
        buf.writeInt(msg.num);
        buf.writeBoolean(msg.check);
        buf.func_211400_a(msg.effect.toString(), 512);
    }

    public static PacketGenericParticleEffect decode(PacketBuffer buf) {
        return new PacketGenericParticleEffect(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readBoolean(), PacketGenericParticleEffect.evaluateEffect(buf));
    }

    private static Effect evaluateEffect(PacketBuffer buf) {
        Effect effect;
        try {
            effect = Effect.valueOf(buf.func_150789_c(512));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            effect = Effect.NONE;
        }
        return effect;
    }

    public static void handle(PacketGenericParticleEffect msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = EnigmaticLegacy.proxy.getClientPlayer();
            Vector3 pos = msg.pos;
            int amount = msg.num;
            if (msg.check) {
                amount = (int)((float)amount * SuperpositionHandler.getParticleMultiplier());
            }
            if (msg.effect == Effect.GUARDIAN_CURSE) {
                int counter;
                double dist = 0.05;
                double distHearts = 0.5;
                for (counter = 0; counter < 4; ++counter) {
                    player.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197609_b, true, pos.x + SuperpositionHandler.getRandomNegative() * distHearts, pos.y + SuperpositionHandler.getRandomNegative() * distHearts, pos.z + SuperpositionHandler.getRandomNegative() * distHearts, SuperpositionHandler.getRandomNegative() * 1.05, SuperpositionHandler.getRandomNegative() * 1.05, SuperpositionHandler.getRandomNegative() * 1.05);
                }
                for (counter = 0; counter < 12; ++counter) {
                    player.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197594_E, true, pos.x, pos.y, pos.z, SuperpositionHandler.getRandomNegative() * dist, SuperpositionHandler.getRandomNegative() * dist, SuperpositionHandler.getRandomNegative() * dist);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Effect {
        NONE,
        GUARDIAN_CURSE;

    }
}

