/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.proxy;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.client.fx.PermanentItemPickupParticle;
import com.integral.enigmaticlegacy.client.renderers.PermanentItemRenderer;
import com.integral.enigmaticlegacy.client.renderers.ShieldAuraLayer;
import com.integral.enigmaticlegacy.client.renderers.UltimateWitherSkullRenderer;
import com.integral.enigmaticlegacy.entities.EnigmaticPotionEntity;
import com.integral.enigmaticlegacy.entities.PermanentItemEntity;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.objects.RevelationTomeToast;
import com.integral.enigmaticlegacy.objects.TransientPlayerData;
import com.integral.enigmaticlegacy.proxy.CommonProxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

public class ClientProxy
extends CommonProxy {
    private static final Random random = new Random();
    protected final HashMap<PlayerEntity, TransientPlayerData> clientTransientPlayerData = new HashMap();

    @Override
    public HashMap<PlayerEntity, TransientPlayerData> getTransientPlayerData(boolean clientOnly) {
        if (clientOnly) {
            return this.clientTransientPlayerData;
        }
        return this.commonTransientPlayerData;
    }

    @Override
    public void handleItemPickup(int pickuper_id, int item_id) {
        try {
            Entity pickuper = Minecraft.func_71410_x().field_71441_e.func_73045_a(pickuper_id);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(item_id);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new PermanentItemPickupParticle(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_228019_au_(), Minecraft.func_71410_x().field_71441_e, pickuper, entity));
            Minecraft.func_71410_x().field_71441_e.func_184134_a(pickuper.func_226277_ct_(), pickuper.func_226278_cu_(), pickuper.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (random.nextFloat() - random.nextFloat()) * 1.4f + 2.0f, false);
        }
        catch (Throwable ex) {
            Exception log = new Exception("Unknown error when rendering permanent item pickup", ex);
            EnigmaticLegacy.logger.catching(log);
        }
    }

    @Override
    public void initAuxiliaryRender() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer renderSteve = (PlayerRenderer)skinMap.get("default");
        PlayerRenderer renderAlex = (PlayerRenderer)skinMap.get("slim");
        renderSteve.func_177094_a((LayerRenderer)new ShieldAuraLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderSteve));
        renderAlex.func_177094_a((LayerRenderer)new ShieldAuraLayer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderAlex));
    }

    @Override
    public void initEntityRendering() {
        RenderingRegistry.registerEntityRenderingHandler(PermanentItemEntity.TYPE, renderManager -> new PermanentItemRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EnigmaticPotionEntity.TYPE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(UltimateWitherSkullEntity.TYPE, UltimateWitherSkullRenderer::new);
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.initAuxiliaryRender();
    }

    @Override
    public boolean isInVanillaDimension(PlayerEntity player) {
        return player.field_70170_p.func_234923_W_().equals(this.getOverworldKey()) || player.field_70170_p.func_234923_W_().equals(this.getNetherKey()) || player.field_70170_p.func_234923_W_().equals(this.getEndKey());
    }

    @Override
    public boolean isInDimension(PlayerEntity player, RegistryKey<World> world) {
        return player.field_70170_p.func_234923_W_().equals(world);
    }

    @Override
    public World getCentralWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public UseAction getVisualBlockAction() {
        return UseAction.BLOCK;
    }

    @Override
    public PlayerEntity getPlayer(UUID playerID) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().field_71441_e.func_217371_b(playerID);
        }
        return null;
    }

    @Override
    public void pushRevelationToast(ItemStack renderedStack, int xp, int knowledge) {
        ToastGui gui = Minecraft.func_71410_x().func_193033_an();
        gui.func_192988_a((IToast)new RevelationTomeToast(renderedStack, xp, knowledge));
    }

    @Override
    public void spawnBonemealParticles(World world, BlockPos pos, int data) {
        BlockState blockstate;
        if (data == 0) {
            data = 15;
        }
        if (!(blockstate = world.func_180495_p(pos)).isAir((IBlockReader)world, pos)) {
            double d1;
            double d0 = 0.5;
            if (blockstate.func_203425_a(Blocks.field_150355_j)) {
                data *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.func_200015_d((IBlockReader)world, pos)) {
                pos = pos.func_177984_a();
                data *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.func_196954_c((IBlockReader)world, pos).func_197758_c(Direction.Axis.Y);
            }
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            for (int i = 0; i < data; ++i) {
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)pos.func_177958_n() + d5 + random.nextDouble() * d0 * 2.0;
                double d7 = (double)pos.func_177956_o() + random.nextDouble() * d1;
                double d8 = (double)pos.func_177952_p() + d5 + random.nextDouble() * d0 * 2.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, d6, d7, d8, d2, d3, d4);
            }
        }
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

