/*
 * Decompiled with CFR 0.152.
 */
package com.integral.omniconfig.packets;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncOptions {
    private Map<String, String> synchronizedParameters = new HashMap<String, String>();
    private String fileName = "";
    private String configVersion = "";

    private PacketSyncOptions(String fileName, String configVersion, Map<String, String> params) {
        this.fileName = fileName;
        this.configVersion = configVersion;
        this.synchronizedParameters = params;
    }

    public PacketSyncOptions(OmniconfigWrapper wrapper) {
        this.fileName = wrapper.config.getConfigFile().getName();
        this.configVersion = wrapper.config.getLoadedConfigVersion();
        for (Omniconfig.GenericParameter param : wrapper.retrieveInvocationList()) {
            if (!param.isSynchronized()) continue;
            this.synchronizedParameters.put(param.getId(), param.valueToString());
        }
    }

    public static void encode(PacketSyncOptions msg, PacketBuffer buf) {
        buf.func_211400_a(msg.fileName, 512);
        buf.func_211400_a(String.valueOf(msg.configVersion), 512);
        buf.writeLong((long)msg.synchronizedParameters.size());
        for (String paramName : msg.synchronizedParameters.keySet()) {
            buf.func_211400_a(paramName, 512);
            buf.func_211400_a(msg.synchronizedParameters.get(paramName), 32768);
        }
    }

    public static PacketSyncOptions decode(PacketBuffer buf) {
        String fileName = buf.func_150789_c(512);
        String configVersion = buf.func_150789_c(512);
        long entryAmount = buf.readLong();
        HashMap<String, String> params = new HashMap<String, String>();
        int counter = 0;
        while ((long)counter < entryAmount) {
            String identifier = buf.func_150789_c(512);
            String value = buf.func_150789_c(32768);
            params.put(identifier, value);
            ++counter;
        }
        return new PacketSyncOptions(fileName, configVersion, params);
    }

    public static void handle(PacketSyncOptions msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            OmniconfigWrapper.onRemoteServer = true;
            OmniconfigWrapper wrapper = OmniconfigWrapper.wrapperRegistry.get(msg.fileName);
            if (wrapper != null) {
                EnigmaticLegacy.logger.info("Synchronizing values of " + msg.fileName + " with ones dispatched by server...");
                for (String id : msg.synchronizedParameters.keySet()) {
                    Omniconfig.GenericParameter parameter = wrapper.invokationMap.get(id);
                    if (parameter != null) {
                        String oldValue = parameter.valueToString();
                        parameter.parseFromString(msg.synchronizedParameters.get(id));
                        EnigmaticLegacy.logger.info("Value of '" + parameter.getId() + "' was set to '" + parameter.valueToString() + "'; old value: " + oldValue);
                        continue;
                    }
                    EnigmaticLegacy.logger.error("Value '" + id + "' does not exist in " + msg.fileName + "! Skipping.");
                }
            } else {
                EnigmaticLegacy.logger.fatal("Received synchronization packet for non-existent config file: " + msg.fileName);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

