/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.entities;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.packets.clients.PacketHandleItemPickup;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;

public class PermanentItemEntity
extends Entity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(PermanentItemEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private int age;
    private int pickupDelay;
    private int health = 5;
    private UUID thrower;
    private UUID owner;
    @ObjectHolder(value="enigmaticlegacy:permanent_item_entity")
    public static EntityType<PermanentItemEntity> TYPE;
    public final float hoverStart = (float)(Math.random() * Math.PI * 2.0);

    public PermanentItemEntity(EntityType<PermanentItemEntity> type, World world) {
        super(type, world);
    }

    public PermanentItemEntity(World worldIn, double x, double y, double z) {
        this(TYPE, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_189654_d(true);
    }

    public PermanentItemEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setItem(stack);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        } else {
            ItemStack item;
            double d0;
            super.func_70071_h_();
            if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
                --this.pickupDelay;
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            Vec3d vec3d = this.func_213322_ci();
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70145_X = false;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t, this.field_70163_u + (double)(this.func_213302_cg() / 2.0f), this.field_70161_v, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0);
            }
            ++this.age;
            if (!this.field_70170_p.field_72995_K && (d0 = this.func_213322_ci().func_178788_d(vec3d).func_189985_c()) > 0.01) {
                this.field_70160_al = true;
            }
            if ((item = this.getItem()).func_190926_b()) {
                this.func_70106_y();
            }
        }
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (source.func_151517_h()) {
            this.func_70106_y();
            return false;
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("Health", (short)this.health);
        compound.func_74777_a("Age", (short)this.age);
        compound.func_74777_a("PickupDelay", (short)this.pickupDelay);
        if (this.getThrowerId() != null) {
            compound.func_218657_a("Thrower", (INBT)NBTUtil.func_186862_a((UUID)this.getThrowerId()));
        }
        if (this.getOwnerId() != null) {
            compound.func_218657_a("Owner", (INBT)NBTUtil.func_186862_a((UUID)this.getOwnerId()));
        }
        if (!this.getItem().func_190926_b()) {
            compound.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.health = compound.func_74765_d("Health");
        this.age = compound.func_74765_d("Age");
        if (compound.func_74764_b("PickupDelay")) {
            this.pickupDelay = compound.func_74765_d("PickupDelay");
        }
        if (compound.func_150297_b("Owner", 10)) {
            this.owner = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("Owner"));
        }
        if (compound.func_150297_b("Thrower", 10)) {
            this.thrower = NBTUtil.func_186860_b((CompoundNBT)compound.func_74775_l("Thrower"));
        }
        CompoundNBT compoundnbt = compound.func_74775_l("Item");
        this.setItem(ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.pickupDelay > 0) {
                return;
            }
            ItemStack itemstack = this.getItem();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            ItemStack copy = itemstack.func_77946_l();
            if (this.pickupDelay == 0 && (this.owner == null || this.owner.equals(entityIn.func_110124_au())) && (i <= 0 || entityIn.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - this.getItem().func_190916_E());
                if (itemstack.func_190926_b()) {
                    entityIn.func_71001_a((Entity)this, i);
                    EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0, this.field_71093_bK)), (Object)new PacketHandleItemPickup(entityIn.func_145782_y(), this.func_145782_y()));
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                entityIn.func_71064_a(Stats.field_199089_f.func_199076_b((Object)item), i);
            }
        }
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TranslationTextComponent(this.getItem().func_77977_a(), new Object[0]);
    }

    public boolean func_70075_an() {
        return false;
    }

    @Nullable
    public Entity func_212321_a(DimensionType destination) {
        Entity entity = super.func_212321_a(destination);
        return entity;
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    public void setOwnerId(@Nullable UUID p_200217_1_) {
        this.owner = p_200217_1_;
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrowerId(@Nullable UUID p_200216_1_) {
        this.thrower = p_200216_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAge() {
        return this.age;
    }

    public void setDefaultPickupDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickupDelay() {
        this.pickupDelay = 0;
    }

    public void setInfinitePickupDelay() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickupDelay(int ticks) {
        this.pickupDelay = ticks;
    }

    public boolean cannotPickup() {
        return this.pickupDelay > 0;
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

