/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import com.integral.enigmaticlegacy.items.EtheriumAxe;
import com.integral.enigmaticlegacy.items.EtheriumPickaxe;
import com.integral.enigmaticlegacy.items.EtheriumShovel;
import com.integral.enigmaticlegacy.packets.clients.PacketFlameParticles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.PacketDistributor;

public class AstralBreaker
extends ToolItem
implements IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public Set<Material> effectiveMaterials = Sets.newHashSet();

    public AstralBreaker(IItemTier tier, Function<Item.Properties, Item.Properties> properties) {
        super(4.0f, -2.8f, tier, new HashSet(), properties.apply(new Item.Properties().func_200915_b((int)((double)tier.func_200926_a() * 1.5)).addToolType(ToolType.PICKAXE, tier.func_200925_d()).addToolType(ToolType.AXE, tier.func_200925_d()).addToolType(ToolType.SHOVEL, tier.func_200925_d())));
        this.effectiveMaterials.addAll(((EtheriumPickaxe)EnigmaticLegacy.etheriumPickaxe).effectiveMaterials);
        this.effectiveMaterials.addAll(((EtheriumAxe)EnigmaticLegacy.etheriumAxe).effectiveMaterials);
        this.effectiveMaterials.addAll(((EtheriumShovel)EnigmaticLegacy.etheriumShovel).effectiveMaterials);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.EPIC);
        integratedProperties.func_200915_b(4000);
        return integratedProperties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker1", 3, 1);
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker3");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return true;
    }

    public void spawnFlameParticles(World world, BlockPos pos) {
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0, world.field_73011_w.func_186058_p())), (Object)new PacketFlameParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 18, true));
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        RayTraceResult trace;
        if (!world.field_72995_K) {
            this.spawnFlameParticles(world, pos);
        }
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_70093_af() && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && ConfigHandler.ETHERIUM_PICKAXE_RADIUS.getValue() != -1 && (trace = AOEMiningHelper.calcRayTrace(world, (PlayerEntity)entityLiving, RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos, this.effectiveMaterials, 3, 1, true, pos, stack, (objPos, objState) -> {
                stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack)));
                this.spawnFlameParticles(world, (BlockPos)objPos);
            });
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public boolean func_150897_b(BlockState blockIn) {
        Block block = blockIn.func_177230_c();
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return i >= blockIn.getHarvestLevel();
        }
        if (blockIn.getHarvestTool() == ToolType.AXE || blockIn.getHarvestTool() == ToolType.SHOVEL) {
            return true;
        }
        Material material = blockIn.func_185904_a();
        return this.effectiveMaterials.contains(material);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

