/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import com.integral.enigmaticlegacy.helpers.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.capability.ICurio;

public class EnigmaticItem
extends Item
implements ICurio {
    public static HashMap<PlayerEntity, Boolean> flightMap = new HashMap();
    public static Item.Properties integratedProperties = new Item.Properties();
    public static List<String> immunityList = new ArrayList<String>();

    public EnigmaticItem(Item.Properties properties) {
        super(properties);
        immunityList.add(DamageSource.field_76379_h.field_76373_n);
        immunityList.add(DamageSource.field_188406_j.field_76373_n);
        immunityList.add(DamageSource.field_76367_g.field_76373_n);
        immunityList.add(DamageSource.field_191291_g.field_76373_n);
        immunityList.add(DamageSource.field_76369_e.field_76373_n);
        immunityList.add(DamageSource.field_190095_e.field_76373_n);
        immunityList.add(DamageSource.field_76371_c.field_76373_n);
        immunityList.add(DamageSource.field_76372_a.field_76373_n);
        immunityList.add(DamageSource.field_76370_b.field_76373_n);
        immunityList.add(DamageSource.field_76368_d.field_76373_n);
        immunityList.add(DamageSource.field_76380_i.field_76373_n);
        immunityList.add(DamageSource.field_76366_f.field_76373_n);
        immunityList.add(DamageSource.field_220302_v.field_76373_n);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.EPIC);
        return integratedProperties;
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.enigmaticItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItemCooldown", Float.valueOf((float)ConfigHandler.ENIGMATIC_ITEM_COOLDOWN.getValue() / 20.0f));
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem6");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem7");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem8");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem9");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem10");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem11");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onCurioTick(String identifier, LivingEntity entityLivingBase) {
        if (entityLivingBase.func_70027_ad()) {
            entityLivingBase.func_70066_B();
        }
        entityLivingBase.func_195061_cb();
    }

    public static void handleEnigmaticFlight(PlayerEntity player) {
        try {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.enigmaticItem)) {
                flightMap.put(player, true);
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
            } else if (flightMap.get(player).booleanValue()) {
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                }
                flightMap.put(player, false);
            }
        }
        catch (NullPointerException ex) {
            flightMap.put(player, false);
        }
    }

    public void triggerActiveAbility(World world, PlayerEntity player, ItemStack stack) {
        if (world.field_72995_K || SuperpositionHandler.hasSpellstoneCooldown(player)) {
            return;
        }
        this.launchWitherSkull(world, player, field_77697_d.nextDouble() <= 0.25);
        SuperpositionHandler.setSpellstoneCooldown(player, ConfigHandler.ENIGMATIC_ITEM_COOLDOWN.getValue());
    }

    private void launchWitherSkull(World world, PlayerEntity player, boolean invulnerable) {
        world.func_217378_a((PlayerEntity)null, 1024, new BlockPos((Entity)player), 0);
        Vector3 look = new Vector3(player.func_70040_Z()).multiply(1.0, 0.0, 1.0);
        double playerRot = Math.toRadians(player.field_70177_z + 90.0f);
        if (look.x == 0.0 && look.z == 0.0) {
            look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
        }
        look = look.normalize().multiply(-2.0);
        double div = -0.75 + field_77697_d.nextDouble() * 0.75;
        double mod = -0.5 + field_77697_d.nextDouble() * 6.0;
        Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)player)).add(0.0, 1.6, div * 0.1);
        Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
        double rot = mod * Math.PI / 4.0 - 1.5707963267948966;
        Vector3 axis1 = axis.multiply(div * 3.5 + 5.0).rotate(rot, look);
        if (axis1.y < 0.0) {
            axis1 = axis1.multiply(1.0, -1.0, 1.0);
        }
        Vector3 end = pl.add(axis1);
        UltimateWitherSkullEntity witherskullentity = new UltimateWitherSkullEntity(world, (LivingEntity)player);
        if (invulnerable) {
            witherskullentity.setSkullInvulnerable(true);
        }
        witherskullentity.field_70165_t = end.x;
        witherskullentity.field_70163_u = end.y;
        witherskullentity.field_70161_v = end.z;
        world.func_217376_c((Entity)witherskullentity);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(witherskullentity.field_70165_t, witherskullentity.field_70163_u, witherskullentity.field_70161_v, 64.0, witherskullentity.field_71093_bK)), (Object)new PacketWitherParticles(witherskullentity.field_70165_t, witherskullentity.field_70163_u + (double)(witherskullentity.func_213302_cg() / 2.0f), witherskullentity.field_70161_v, 8, false));
    }
}

