/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.CooldownMap;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import com.integral.enigmaticlegacy.helpers.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EtheriumSword
extends SwordItem
implements IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static CooldownMap etheriumSwordCooldowns = new CooldownMap();

    public EtheriumSword(Item.Properties properties, IItemTier tier, float attackSpeedIn, int attackDamageIn) {
        super(tier, attackDamageIn, attackSpeedIn, properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.RARE);
        return integratedProperties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword4", Float.valueOf((float)ConfigHandler.ETHERIUM_SWORD_COOLDOWN.getValue() / 20.0f));
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_TOOLS_ENABLED.getValue();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND) {
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        if (!etheriumSwordCooldowns.hasCooldown((LivingEntity)player) && !player.field_70170_p.field_72995_K) {
            Vector3 look = new Vector3(player.func_70040_Z());
            Vector3 dir = look.multiply(1.0);
            this.knockBack(player, 1.0f, dir.x, dir.z);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187866_fi, SoundCategory.PLAYERS, 1.0f, (float)((double)0.6f + Math.random() * 0.1));
            etheriumSwordCooldowns.put(player, ConfigHandler.ETHERIUM_SWORD_COOLDOWN.getValue());
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void knockBack(PlayerEntity entityIn, float strength, double xRatio, double zRatio) {
        entityIn.field_70160_al = true;
        Vec3d vec3d = new Vec3d(0.0, 0.0, 0.0);
        Vec3d vec3d1 = new Vec3d(xRatio, 0.0, zRatio).func_72432_b().func_186678_a((double)strength);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entityIn), (Object)new PacketPlayerMotion(vec3d.field_72450_a / 2.0 - vec3d1.field_72450_a, entityIn.field_70122_E ? Math.min(0.4, vec3d.field_72448_b / 2.0 + (double)strength) : vec3d.field_72448_b, vec3d.field_72449_c / 2.0 - vec3d1.field_72449_c));
        entityIn.func_213293_j(vec3d.field_72450_a / 2.0 - vec3d1.field_72450_a, entityIn.field_70122_E ? Math.min(0.4, vec3d.field_72448_b / 2.0 + (double)strength) : vec3d.field_72448_b, vec3d.field_72449_c / 2.0 - vec3d1.field_72449_c);
    }
}

