/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class HeavenScroll
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static HashMap<PlayerEntity, Boolean> flyMap = new HashMap();

    public HeavenScroll(Item.Properties properties) {
        super(properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.EPIC);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.HEAVEN_SCROLL_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.heavenScroll);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome3");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            if (Math.random() <= 0.025 * ConfigHandler.HEAVEN_SCROLL_XP_COST_MODIFIER.getValue() & player.field_71075_bZ.field_75100_b) {
                player.func_195068_e(-1);
            }
            try {
                if (player.field_71067_cb > 0) {
                    if (!player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                    }
                    player.func_71016_p();
                    flyMap.put(player, true);
                } else if (flyMap.get(player).booleanValue()) {
                    if (!player.func_184812_l_()) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.func_71016_p();
                    }
                    flyMap.put(player, false);
                }
            }
            catch (NullPointerException ex) {
                flyMap.put(player, false);
            }
        }
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
        if (entityLivingBase instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLivingBase;
            if (!player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
            flyMap.put(player, false);
        }
    }
}

