/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LootGenerator
extends Item {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static Random lootRandomizer = new Random();
    public static List<ResourceLocation> lootList = new ArrayList<ResourceLocation>();

    public LootGenerator(Item.Properties properties) {
        super(properties);
        lootList.add(LootTables.field_186420_b);
        lootList.add(LootTables.field_186421_c);
        lootList.add(LootTables.field_186422_d);
        lootList.add(LootTables.field_215814_e);
        lootList.add(LootTables.field_215815_f);
        lootList.add(LootTables.field_215816_g);
        lootList.add(LootTables.field_215817_h);
        lootList.add(LootTables.field_215818_i);
        lootList.add(LootTables.field_215819_j);
        lootList.add(LootTables.field_215820_k);
        lootList.add(LootTables.field_215821_l);
        lootList.add(LootTables.field_215822_m);
        lootList.add(LootTables.field_215823_n);
        lootList.add(LootTables.field_215824_o);
        lootList.add(LootTables.field_215825_p);
        lootList.add(LootTables.field_215826_q);
        lootList.add(LootTables.field_215827_r);
        lootList.add(LootTables.field_215828_s);
        lootList.add(LootTables.field_215829_t);
        lootList.add(LootTables.field_186424_f);
        lootList.add(LootTables.field_186425_g);
        lootList.add(LootTables.field_186426_h);
        lootList.add(LootTables.field_186427_i);
        lootList.add(LootTables.field_186428_j);
        lootList.add(LootTables.field_186429_k);
        lootList.add(LootTables.field_186430_l);
        lootList.add(LootTables.field_189420_m);
        lootList.add(LootTables.field_186431_m);
        lootList.add(LootTables.field_191192_o);
        lootList.add(LootTables.field_204114_p);
        lootList.add(LootTables.field_204115_q);
        lootList.add(LootTables.field_204312_r);
        lootList.add(LootTables.field_204771_s);
        lootList.add(LootTables.field_204772_t);
        lootList.add(LootTables.field_204773_u);
        lootList.add(LootTables.field_215813_K);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.EPIC);
        return integratedProperties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator6");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator7");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator8");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGenerator9");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.lootGeneratorCurrent");
        list.add(new TranslationTextComponent("tooltip.enigmaticlegacy.code6", new Object[0]).func_150258_a("" + lootList.get(stack.func_77952_i())));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            player.func_184598_c(hand);
            if (itemstack.func_77952_i() < lootList.size() - 1) {
                itemstack.func_196085_b(itemstack.func_77952_i() + 1);
            } else {
                itemstack.func_196085_b(0);
            }
            player.func_184609_a(hand);
        } else {
            if (itemstack.func_77952_i() > 0) {
                itemstack.func_196085_b(itemstack.func_77952_i() - 1);
            } else {
                itemstack.func_196085_b(lootList.size() - 1);
            }
            player.func_184609_a(hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (world.func_180495_p(context.func_195995_a()).hasTileEntity() && world.func_175625_s(context.func_195995_a()) instanceof ChestTileEntity) {
            ChestTileEntity chest = (ChestTileEntity)world.func_175625_s(context.func_195995_a());
            if (context.func_196000_l() == Direction.UP) {
                chest.func_189404_a(lootList.get(stack.func_77952_i()), lootRandomizer.nextLong());
                chest.func_184281_d(player);
            } else if (context.func_196000_l() == Direction.DOWN) {
                HashMap<Item, Integer> lootMap = new HashMap<Item, Integer>();
                for (int counter = 0; counter < 32768; ++counter) {
                    chest.func_189404_a(lootList.get(stack.func_77952_i()), lootRandomizer.nextLong());
                    chest.func_184281_d(player);
                    for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                        ItemStack generatedStack = chest.func_70301_a(slot);
                        Item generatedItem = generatedStack.func_77973_b();
                        int amount = generatedStack.func_190916_E();
                        if (generatedStack.func_190926_b()) continue;
                        if (lootMap.containsKey(generatedItem)) {
                            lootMap.put(generatedItem, (Integer)lootMap.get(generatedItem) + amount);
                            continue;
                        }
                        lootMap.put(generatedItem, amount);
                    }
                    chest.func_174888_l();
                }
                EnigmaticLegacy.enigmaticLogger.info("Estimated generation complete in 32768 instances, results:");
                for (Item theItem : lootMap.keySet()) {
                    EnigmaticLegacy.enigmaticLogger.info("Item: " + theItem.func_200295_i(new ItemStack((IItemProvider)theItem)).func_150261_e() + ", Amount: " + lootMap.get(theItem));
                }
                player.func_145747_a(new TranslationTextComponent("message.enigmaticlegacy.gen_sim_complete", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            } else {
                chest.func_174888_l();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

