/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.CooldownMap;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.capability.ICurio;

public class Megasponge
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static CooldownMap cooldownMap = new CooldownMap();

    public Megasponge(Item.Properties properties) {
        super(properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.UNCOMMON);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MEGASPONGE_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.megaSponge);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.megaSponge1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.megaSponge2");
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public BlockPos getCollidedWater(Tag<Fluid> p_210500_1_, PlayerEntity player) {
        AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos pos = null;
        if (!player.field_70170_p.func_217344_a(i, k, i1, j, l, j1)) {
            return null;
        }
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = k; i2 < l; ++i2) {
                    for (int j2 = i1; j2 < j1; ++j2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, i2, j2);
                        IFluidState ifluidstate = player.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutableblockpos);
                        if (!ifluidstate.func_206884_a(p_210500_1_)) continue;
                        ifluidstate.func_215679_a((IBlockReader)player.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        pos = new BlockPos(l1, i2, j2);
                    }
                }
            }
        }
        return pos;
    }

    public void onCurioTick(String identifier, LivingEntity living) {
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)living;
            cooldownMap.tick(living);
            if (!cooldownMap.hasCooldown((LivingEntity)player)) {
                BlockState initialState;
                ArrayList<BlockPos> doomedWaterBlocks = new ArrayList<BlockPos>();
                BlockPos initialPos = this.getCollidedWater((Tag<Fluid>)FluidTags.field_206959_a, player);
                BlockState blockState = initialState = initialPos != null ? player.field_70170_p.func_180495_p(initialPos) : null;
                if (initialPos != null && initialState.func_204520_s() != null && initialState.func_204520_s().func_206884_a(FluidTags.field_206959_a)) {
                    doomedWaterBlocks.add(initialPos);
                    ArrayList<BlockPos> processedBlocks = new ArrayList<BlockPos>();
                    processedBlocks.add(initialPos);
                    for (int counter = 0; counter <= ConfigHandler.EXTRAPOLATED_MEGASPONGE_RADIUS.getValue(); ++counter) {
                        ArrayList<BlockPos> outputBlocks = new ArrayList<BlockPos>();
                        for (BlockPos checkedPos : processedBlocks) {
                            outputBlocks.addAll(Megasponge.getNearbyWater(player.field_70170_p, checkedPos));
                        }
                        processedBlocks.clear();
                        for (BlockPos thePos : outputBlocks) {
                            if (doomedWaterBlocks.contains(thePos)) continue;
                            processedBlocks.add(thePos);
                            doomedWaterBlocks.add(thePos);
                        }
                        outputBlocks.clear();
                    }
                    processedBlocks.clear();
                    for (BlockPos exterminatedBlock : doomedWaterBlocks) {
                        Megasponge.absorbWaterBlock(exterminatedBlock, player.field_70170_p.func_180495_p(exterminatedBlock), player.field_70170_p);
                    }
                    doomedWaterBlocks.clear();
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                    EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0, player.field_71093_bK)), (Object)new PacketPortalParticles(player.field_70165_t, player.field_70163_u + (double)(player.func_213302_cg() / 2.0f), player.field_70161_v, 40, 1.0, false));
                    cooldownMap.put(player, 20);
                }
            }
        }
    }

    public static void absorbWaterBlock(BlockPos pos, BlockState state, World world) {
        if (!(state.func_177230_c() instanceof IBucketPickupHandler) || ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state) == Fluids.field_204541_a) {
            if (state.func_177230_c() instanceof FlowingFluidBlock) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_204868_h) {
                TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
                Block.func_220059_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tileentity);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public static List<BlockPos> getNearbyWater(World world, BlockPos pos) {
        ArrayList<BlockPos> nearBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> waterBlocks = new ArrayList<BlockPos>();
        nearBlocks.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
        for (BlockPos checkedPos : nearBlocks) {
            if (!world.func_180495_p(checkedPos).func_204520_s().func_206884_a(FluidTags.field_206959_a)) continue;
            waterBlocks.add(checkedPos);
        }
        return waterBlocks;
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }
}

