/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class MonsterCharm
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static float bonusXPModifier = 2.0f;

    public MonsterCharm(Item.Properties properties) {
        super(properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.EPIC);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MONSTER_CHARM_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.monsterCharm);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm1", ConfigHandler.MONSTER_CHARM_UNDEAD_DAMAGE.getValue().asPercentage() + "%");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm2", ConfigHandler.MONSTER_CHARM_AGGRESSIVE_DAMAGE.getValue().asPercentage() + "%");
            if (ConfigHandler.MONSTER_CHARM_BONUS_LOOTING.getValue()) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm3");
            }
            if (ConfigHandler.MONSTER_CHARM_DOUBLE_XP.getValue()) {
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
                LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.monsterCharm4");
            }
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public void onCurioTick(String identifier, LivingEntity living) {
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }
}

