/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.IPerhaps;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.LoreHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.capability.ICurio;

public class XPScroll
extends Item
implements ICurio,
IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public static final int xpPortion = 5;

    public XPScroll(Item.Properties properties) {
        super(properties);
    }

    public static Item.Properties setupIntegratedProperties() {
        integratedProperties.func_200916_a(EnigmaticLegacy.enigmaticTab);
        integratedProperties.func_200917_a(1);
        integratedProperties.func_208103_a(Rarity.UNCOMMON);
        return integratedProperties;
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.XP_SCROLL_ENABLED.getValue();
    }

    public boolean canEquip(String identifier, LivingEntity living) {
        return !SuperpositionHandler.hasCurio(living, EnigmaticLegacy.xpScroll);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        TranslationTextComponent cMode = !ItemNBTHelper.getBoolean(stack, "IsActive", false) ? new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeDeactivated", new Object[0]) : (ItemNBTHelper.getBoolean(stack, "AbsorptionMode", true) ? new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeAbsorption", new Object[0]) : new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeExtraction", new Object[0]));
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (ControlsScreen.hasShiftDown()) {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome1");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome2");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome3");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome4");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome4_5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome5");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome6");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome7");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome8");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome9");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome10");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome11", (int)ConfigHandler.XP_SCROLL_COLLECTION_RANGE.getValue());
        } else {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeMode", cMode.func_150254_d());
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeStoredXP");
        LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeUnits", ItemNBTHelper.getInt(stack, "XPStored", 0), ExperienceHelper.getLevelForExperience(ItemNBTHelper.getInt(stack, "XPStored", 0)));
        try {
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            LoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.xpScroll").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        this.trigger(world, stack, player, handIn, true);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void trigger(World world, ItemStack stack, PlayerEntity player, Hand hand, boolean swing) {
        if (!player.func_70093_af()) {
            if (ItemNBTHelper.getBoolean(stack, "AbsorptionMode", true)) {
                ItemNBTHelper.setBoolean(stack, "AbsorptionMode", false);
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            } else {
                ItemNBTHelper.setBoolean(stack, "AbsorptionMode", true);
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        } else if (ItemNBTHelper.getBoolean(stack, "IsActive", false)) {
            ItemNBTHelper.setBoolean(stack, "IsActive", false);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHOFF, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean(stack, "IsActive", true);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHON, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        if (swing) {
            player.func_184609_a(hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, "IsActive", false);
    }

    public void onCurioTick(String identifier, LivingEntity entity) {
        ItemStack itemstack = SuperpositionHandler.getCurioStack(entity, EnigmaticLegacy.xpScroll);
        if (!(entity instanceof PlayerEntity) || entity.field_70170_p.field_72995_K || !ItemNBTHelper.getBoolean(itemstack, "IsActive", false)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        World world = player.field_70170_p;
        if (ItemNBTHelper.getBoolean(itemstack, "AbsorptionMode", true)) {
            if (player.field_71067_cb >= 5) {
                player.func_195068_e(-5);
                ItemNBTHelper.setInt(itemstack, "XPStored", ItemNBTHelper.getInt(itemstack, "XPStored", 0) + 5);
            } else if (player.field_71067_cb > 0 & ExperienceHelper.getPlayerXP(player) < 5) {
                int exp = player.field_71067_cb;
                player.func_195068_e(-exp);
                ItemNBTHelper.setInt(itemstack, "XPStored", ItemNBTHelper.getInt(itemstack, "XPStored", 0) + exp);
            }
        } else {
            int xp = ItemNBTHelper.getInt(itemstack, "XPStored", 0);
            if (xp >= 5) {
                ItemNBTHelper.setInt(itemstack, "XPStored", xp - 5);
                player.func_195068_e(5);
            } else if (xp > 0 & xp < 5) {
                ItemNBTHelper.setInt(itemstack, "XPStored", 0);
                player.func_195068_e(xp);
            }
        }
        List orbs = world.func_217357_a(ExperienceOrbEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, ConfigHandler.XP_SCROLL_COLLECTION_RANGE.getValue()));
        for (ExperienceOrbEntity processed : orbs) {
            if (!processed.func_70089_S()) continue;
            player.field_71090_bL = 0;
            processed.func_70100_b_(player);
        }
    }

    public boolean canRightClickEquip() {
        return false;
    }

    public void onEquipped(String identifier, LivingEntity entityLivingBase) {
    }

    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
    }
}

