/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy;

import com.integral.enigmaticlegacy.api.items.IAdvancedPotionItem;
import com.integral.enigmaticlegacy.api.materials.EnigmaticArmorMaterials;
import com.integral.enigmaticlegacy.brewing.SpecialBrewingRecipe;
import com.integral.enigmaticlegacy.brewing.ValidationBrewingRecipe;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.crafting.EnigmaticRecipeSerializers;
import com.integral.enigmaticlegacy.entities.EnigmaticPotionEntity;
import com.integral.enigmaticlegacy.entities.PermanentItemEntity;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.integral.enigmaticlegacy.handlers.EnigmaticKeybindHandler;
import com.integral.enigmaticlegacy.handlers.EnigmaticUpdateHandler;
import com.integral.enigmaticlegacy.handlers.OneSpecialHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ObfuscatedFields;
import com.integral.enigmaticlegacy.helpers.PotionHelper;
import com.integral.enigmaticlegacy.items.AngelBlessing;
import com.integral.enigmaticlegacy.items.AstralBreaker;
import com.integral.enigmaticlegacy.items.AstralDust;
import com.integral.enigmaticlegacy.items.EnchantmentTransposer;
import com.integral.enigmaticlegacy.items.EnderRing;
import com.integral.enigmaticlegacy.items.EnderRod;
import com.integral.enigmaticlegacy.items.EnigmaticAmulet;
import com.integral.enigmaticlegacy.items.EnigmaticItem;
import com.integral.enigmaticlegacy.items.EscapeScroll;
import com.integral.enigmaticlegacy.items.EtheriumArmor;
import com.integral.enigmaticlegacy.items.EtheriumAxe;
import com.integral.enigmaticlegacy.items.EtheriumIngot;
import com.integral.enigmaticlegacy.items.EtheriumOre;
import com.integral.enigmaticlegacy.items.EtheriumPickaxe;
import com.integral.enigmaticlegacy.items.EtheriumScythe;
import com.integral.enigmaticlegacy.items.EtheriumShovel;
import com.integral.enigmaticlegacy.items.EtheriumSword;
import com.integral.enigmaticlegacy.items.ExtradimensionalEye;
import com.integral.enigmaticlegacy.items.EyeOfNebula;
import com.integral.enigmaticlegacy.items.ForbiddenAxe;
import com.integral.enigmaticlegacy.items.GemOfBinding;
import com.integral.enigmaticlegacy.items.GolemHeart;
import com.integral.enigmaticlegacy.items.HastePotion;
import com.integral.enigmaticlegacy.items.HeavenScroll;
import com.integral.enigmaticlegacy.items.IronRing;
import com.integral.enigmaticlegacy.items.LootGenerator;
import com.integral.enigmaticlegacy.items.LoreFragment;
import com.integral.enigmaticlegacy.items.LoreInscriber;
import com.integral.enigmaticlegacy.items.MagmaHeart;
import com.integral.enigmaticlegacy.items.MagnetRing;
import com.integral.enigmaticlegacy.items.Megasponge;
import com.integral.enigmaticlegacy.items.MendingMixture;
import com.integral.enigmaticlegacy.items.MiningCharm;
import com.integral.enigmaticlegacy.items.MonsterCharm;
import com.integral.enigmaticlegacy.items.OblivionStone;
import com.integral.enigmaticlegacy.items.OceanStone;
import com.integral.enigmaticlegacy.items.RecallPotion;
import com.integral.enigmaticlegacy.items.RelicOfTesting;
import com.integral.enigmaticlegacy.items.SuperMagnetRing;
import com.integral.enigmaticlegacy.items.ThiccScroll;
import com.integral.enigmaticlegacy.items.UltimatePotionBase;
import com.integral.enigmaticlegacy.items.UltimatePotionLingering;
import com.integral.enigmaticlegacy.items.UltimatePotionSplash;
import com.integral.enigmaticlegacy.items.UnholyGrail;
import com.integral.enigmaticlegacy.items.VoidPearl;
import com.integral.enigmaticlegacy.items.WormholePotion;
import com.integral.enigmaticlegacy.items.XPScroll;
import com.integral.enigmaticlegacy.objects.AdvancedPotion;
import com.integral.enigmaticlegacy.packets.clients.PacketFlameParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketHandleItemPickup;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerRotations;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerSetlook;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketSlotUnlocked;
import com.integral.enigmaticlegacy.packets.clients.PacketUpdateNotification;
import com.integral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import com.integral.enigmaticlegacy.packets.server.PacketAnvilField;
import com.integral.enigmaticlegacy.packets.server.PacketConfirmTeleportation;
import com.integral.enigmaticlegacy.packets.server.PacketEnderRingKey;
import com.integral.enigmaticlegacy.packets.server.PacketSpellstoneKey;
import com.integral.enigmaticlegacy.packets.server.PacketXPScrollKey;
import com.integral.enigmaticlegacy.proxy.ClientProxy;
import com.integral.enigmaticlegacy.proxy.CommonProxy;
import com.integral.enigmaticlegacy.triggers.BeheadingTrigger;
import com.integral.enigmaticlegacy.triggers.UseUnholyGrailTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enigmaticlegacy")
public class EnigmaticLegacy {
    public static EnigmaticLegacy enigmaticLegacy;
    public static final Logger enigmaticLogger;
    public static SimpleChannel packetInstance;
    public static final String MODID = "enigmaticlegacy";
    public static final String VERSION = "1.7.1";
    public static final String RELEASE_TYPE = "Release";
    public static final String NAME = "Enigmatic Legacy";
    public static final int howCoolAmI = Integer.MAX_VALUE;
    public static EnigmaticEventHandler enigmaticHandler;
    public static EnigmaticKeybindHandler keybindHandler;
    public static final OneSpecialHandler butImAsGuiltyAsThe;
    public static List<String> damageTypesFire;
    public static List<AdvancedPotion> ultimatePotionTypes;
    public static List<AdvancedPotion> commonPotionTypes;
    public static SoundEvent HHON;
    public static SoundEvent HHOFF;
    public static SoundEvent SHIELD_TRIGGER;
    public static EnigmaticItem enigmaticItem;
    public static XPScroll xpScroll;
    public static EnigmaticAmulet enigmaticAmulet;
    public static MagnetRing magnetRing;
    public static ExtradimensionalEye extradimensionalEye;
    public static RelicOfTesting relicOfTesting;
    public static RecallPotion recallPotion;
    public static ForbiddenAxe forbiddenAxe;
    public static EscapeScroll escapeScroll;
    public static HeavenScroll heavenScroll;
    public static SuperMagnetRing superMagnetRing;
    public static GolemHeart golemHeart;
    public static Megasponge megaSponge;
    public static UnholyGrail unholyGrail;
    public static EyeOfNebula eyeOfNebula;
    public static MagmaHeart magmaHeart;
    public static VoidPearl voidPearl;
    public static OceanStone oceanStone;
    public static AngelBlessing angelBlessing;
    public static MonsterCharm monsterCharm;
    public static MiningCharm miningCharm;
    public static EnderRing enderRing;
    public static MendingMixture mendingMixture;
    public static LootGenerator lootGenerator;
    public static ThiccScroll thiccScroll;
    public static IronRing ironRing;
    public static HastePotion hastePotionDefault;
    public static HastePotion hastePotionExtended;
    public static HastePotion hastePotionEmpowered;
    public static HastePotion hastePotionExtendedEmpowered;
    public static EtheriumOre etheriumOre;
    public static EtheriumIngot etheriumIngot;
    public static UltimatePotionBase ultimatePotionBase;
    public static UltimatePotionSplash ultimatePotionSplash;
    public static UltimatePotionLingering ultimatePotionLingering;
    public static UltimatePotionBase commonPotionBase;
    public static UltimatePotionSplash commonPotionSplash;
    public static UltimatePotionLingering commonPotionLingering;
    public static EtheriumArmor etheriumHelmet;
    public static EtheriumArmor etheriumChestplate;
    public static EtheriumArmor etheriumLeggings;
    public static EtheriumArmor etheriumBoots;
    public static EtheriumPickaxe etheriumPickaxe;
    public static EtheriumAxe etheriumAxe;
    public static EtheriumShovel etheriumShovel;
    public static EtheriumSword etheriumSword;
    public static EtheriumScythe etheriumScythe;
    public static AstralDust astralDust;
    public static LoreInscriber loreInscriber;
    public static LoreFragment loreFragment;
    public static EnderRod enderRod;
    public static AstralBreaker astralBreaker;
    public static OblivionStone oblivionStone;
    public static EnchantmentTransposer enchantmentTransposer;
    public static GemOfBinding gemOfBinding;
    public static WormholePotion wormholePotion;
    public static AdvancedPotion ULTIMATE_NIGHT_VISION;
    public static AdvancedPotion ULTIMATE_INVISIBILITY;
    public static AdvancedPotion ULTIMATE_LEAPING;
    public static AdvancedPotion ULTIMATE_FIRE_RESISTANCE;
    public static AdvancedPotion ULTIMATE_SWIFTNESS;
    public static AdvancedPotion ULTIMATE_SLOWNESS;
    public static AdvancedPotion ULTIMATE_TURTLE_MASTER;
    public static AdvancedPotion ULTIMATE_WATER_BREATHING;
    public static AdvancedPotion ULTIMATE_HEALING;
    public static AdvancedPotion ULTIMATE_HARMING;
    public static AdvancedPotion ULTIMATE_POISON;
    public static AdvancedPotion ULTIMATE_REGENERATION;
    public static AdvancedPotion ULTIMATE_STRENGTH;
    public static AdvancedPotion ULTIMATE_WEAKNESS;
    public static AdvancedPotion ULTIMATE_SLOW_FALLING;
    public static AdvancedPotion HASTE;
    public static AdvancedPotion LONG_HASTE;
    public static AdvancedPotion STRONG_HASTE;
    public static AdvancedPotion ULTIMATE_HASTE;
    public static AdvancedPotion EMPTY;
    public static AdvancedPotion testingPotion;
    public static ItemStack universalClock;
    public static UUID soulOfTheArchitect;
    private static final String PTC_VERSION = "1";
    public static final CommonProxy proxy;
    public static final ItemGroup enigmaticTab;
    public static final ItemGroup enigmaticPotionTab;

    public EnigmaticLegacy() {
        enigmaticLogger.info("Constructing mod instance...");
        enigmaticLegacy = this;
        enigmaticHandler = new EnigmaticEventHandler();
        keybindHandler = new EnigmaticKeybindHandler();
        enigmaticItem = new EnigmaticItem();
        xpScroll = new XPScroll();
        enigmaticAmulet = new EnigmaticAmulet();
        magnetRing = new MagnetRing();
        extradimensionalEye = new ExtradimensionalEye();
        relicOfTesting = new RelicOfTesting();
        recallPotion = new RecallPotion();
        forbiddenAxe = new ForbiddenAxe();
        escapeScroll = new EscapeScroll();
        heavenScroll = new HeavenScroll();
        superMagnetRing = new SuperMagnetRing();
        golemHeart = new GolemHeart();
        megaSponge = new Megasponge();
        unholyGrail = new UnholyGrail();
        eyeOfNebula = new EyeOfNebula();
        magmaHeart = new MagmaHeart();
        voidPearl = new VoidPearl();
        oceanStone = new OceanStone();
        angelBlessing = new AngelBlessing();
        monsterCharm = new MonsterCharm();
        miningCharm = new MiningCharm();
        enderRing = new EnderRing();
        mendingMixture = new MendingMixture();
        lootGenerator = new LootGenerator();
        thiccScroll = new ThiccScroll();
        ironRing = new IronRing();
        etheriumOre = new EtheriumOre();
        etheriumIngot = new EtheriumIngot();
        hastePotionDefault = (HastePotion)new HastePotion(Rarity.COMMON, 3600, 0).setRegistryName(new ResourceLocation(MODID, "haste_potion_default"));
        hastePotionExtended = (HastePotion)new HastePotion(Rarity.COMMON, 9600, 0).setRegistryName(new ResourceLocation(MODID, "haste_potion_extended"));
        hastePotionEmpowered = (HastePotion)new HastePotion(Rarity.COMMON, 1800, 1).setRegistryName(new ResourceLocation(MODID, "haste_potion_empowered"));
        hastePotionExtendedEmpowered = (HastePotion)new HastePotion(Rarity.RARE, 4800, 1).setRegistryName(new ResourceLocation(MODID, "haste_potion_extended_empowered"));
        commonPotionBase = (UltimatePotionBase)new UltimatePotionBase(Rarity.COMMON, IAdvancedPotionItem.PotionType.COMMON).setRegistryName(new ResourceLocation(MODID, "common_potion"));
        commonPotionSplash = (UltimatePotionSplash)new UltimatePotionSplash(Rarity.COMMON, IAdvancedPotionItem.PotionType.COMMON).setRegistryName(new ResourceLocation(MODID, "common_potion_splash"));
        commonPotionLingering = (UltimatePotionLingering)new UltimatePotionLingering(Rarity.COMMON, IAdvancedPotionItem.PotionType.COMMON).setRegistryName(new ResourceLocation(MODID, "common_potion_lingering"));
        ultimatePotionBase = (UltimatePotionBase)new UltimatePotionBase(Rarity.RARE, IAdvancedPotionItem.PotionType.ULTIMATE).setRegistryName(new ResourceLocation(MODID, "ultimate_potion"));
        ultimatePotionSplash = (UltimatePotionSplash)new UltimatePotionSplash(Rarity.RARE, IAdvancedPotionItem.PotionType.ULTIMATE).setRegistryName(new ResourceLocation(MODID, "ultimate_potion_splash"));
        ultimatePotionLingering = (UltimatePotionLingering)new UltimatePotionLingering(Rarity.RARE, IAdvancedPotionItem.PotionType.ULTIMATE).setRegistryName(new ResourceLocation(MODID, "ultimate_potion_lingering"));
        etheriumHelmet = (EtheriumArmor)new EtheriumArmor(EnigmaticArmorMaterials.ETHERIUM, EquipmentSlotType.HEAD).setRegistryName(new ResourceLocation(MODID, "etherium_helmet"));
        etheriumChestplate = (EtheriumArmor)new EtheriumArmor(EnigmaticArmorMaterials.ETHERIUM, EquipmentSlotType.CHEST).setRegistryName(new ResourceLocation(MODID, "etherium_chestplate"));
        etheriumLeggings = (EtheriumArmor)new EtheriumArmor(EnigmaticArmorMaterials.ETHERIUM, EquipmentSlotType.LEGS).setRegistryName(new ResourceLocation(MODID, "etherium_leggings"));
        etheriumBoots = (EtheriumArmor)new EtheriumArmor(EnigmaticArmorMaterials.ETHERIUM, EquipmentSlotType.FEET).setRegistryName(new ResourceLocation(MODID, "etherium_boots"));
        etheriumPickaxe = new EtheriumPickaxe();
        etheriumAxe = new EtheriumAxe();
        etheriumShovel = new EtheriumShovel();
        etheriumSword = new EtheriumSword();
        etheriumScythe = new EtheriumScythe();
        astralDust = new AstralDust();
        loreInscriber = new LoreInscriber();
        loreFragment = new LoreFragment();
        enderRod = new EnderRod();
        astralBreaker = new AstralBreaker();
        oblivionStone = new OblivionStone();
        enchantmentTransposer = new EnchantmentTransposer();
        gemOfBinding = new GemOfBinding();
        wormholePotion = new WormholePotion();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::intermodStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EnigmaticRecipeSerializers());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)enigmaticHandler);
        MinecraftForge.EVENT_BUS.register((Object)keybindHandler);
        MinecraftForge.EVENT_BUS.register((Object)new EnigmaticUpdateHandler());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.COMMON, "enigmatic-legacy-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT, "enigmatic-legacy-client.toml");
        enigmaticLogger.info("Mod instance constructed successfully.");
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        enigmaticLogger.info("Initializing load completion phase...");
        enigmaticLogger.info("Initializing config values...");
        if (!((String)ConfigHandler.CONFIG_VERSION.get()).equals("1.1")) {
            ConfigHandler.resetConfig();
            ConfigHandler.CONFIG_VERSION.set((Object)"1.1");
            ConfigHandler.CONFIG_VERSION.save();
        }
        golemHeart.initAttributes();
        enigmaticLogger.info("Registering brewing recipes...");
        if (ConfigHandler.RECALL_POTION_ENABLED.getValue()) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new SpecialBrewingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185233_e)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151061_bv}), new ItemStack((IItemProvider)recallPotion)));
        }
        if (ConfigHandler.COMMON_POTIONS_ENABLED.getValue()) {
            PotionHelper.registerCommonPotions();
        }
        if (ConfigHandler.ULTIMATE_POTIONS_ENABLED.getValue()) {
            PotionHelper.registerBasicUltimatePotions();
            PotionHelper.registerSplashUltimatePotions();
            PotionHelper.registerLingeringUltimatePotions();
        }
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ValidationBrewingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{hastePotionExtendedEmpowered, recallPotion, ultimatePotionLingering, commonPotionLingering}), null));
        EnigmaticUpdateHandler.init();
        proxy.loadComplete(event);
        universalClock = new ItemStack((IItemProvider)Items.field_151113_aN);
        soulOfTheArchitect = UUID.fromString("3efc546d-30bb-4c29-bb61-b3081a118408");
        enigmaticLogger.info("Load completion phase finished successfully");
    }

    private void setup(FMLCommonSetupEvent event) {
        enigmaticLogger.info("Initializing common setup phase...");
        damageTypesFire.add(DamageSource.field_76371_c.field_76373_n);
        damageTypesFire.add(DamageSource.field_76372_a.field_76373_n);
        damageTypesFire.add(DamageSource.field_76370_b.field_76373_n);
        enigmaticLogger.info("Registering packets...");
        packetInstance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        packetInstance.registerMessage(0, PacketRecallParticles.class, PacketRecallParticles::encode, PacketRecallParticles::decode, PacketRecallParticles::handle);
        packetInstance.registerMessage(1, PacketEnderRingKey.class, PacketEnderRingKey::encode, PacketEnderRingKey::decode, PacketEnderRingKey::handle);
        packetInstance.registerMessage(2, PacketSpellstoneKey.class, PacketSpellstoneKey::encode, PacketSpellstoneKey::decode, PacketSpellstoneKey::handle);
        packetInstance.registerMessage(3, PacketPlayerMotion.class, PacketPlayerMotion::encode, PacketPlayerMotion::decode, PacketPlayerMotion::handle);
        packetInstance.registerMessage(4, PacketPlayerRotations.class, PacketPlayerRotations::encode, PacketPlayerRotations::decode, PacketPlayerRotations::handle);
        packetInstance.registerMessage(5, PacketPlayerSetlook.class, PacketPlayerSetlook::encode, PacketPlayerSetlook::decode, PacketPlayerSetlook::handle);
        packetInstance.registerMessage(7, PacketConfirmTeleportation.class, PacketConfirmTeleportation::encode, PacketConfirmTeleportation::decode, PacketConfirmTeleportation::handle);
        packetInstance.registerMessage(8, PacketPortalParticles.class, PacketPortalParticles::encode, PacketPortalParticles::decode, PacketPortalParticles::handle);
        packetInstance.registerMessage(9, PacketXPScrollKey.class, PacketXPScrollKey::encode, PacketXPScrollKey::decode, PacketXPScrollKey::handle);
        packetInstance.registerMessage(10, PacketSlotUnlocked.class, PacketSlotUnlocked::encode, PacketSlotUnlocked::decode, PacketSlotUnlocked::handle);
        packetInstance.registerMessage(11, PacketHandleItemPickup.class, PacketHandleItemPickup::encode, PacketHandleItemPickup::decode, PacketHandleItemPickup::handle);
        packetInstance.registerMessage(12, PacketUpdateNotification.class, PacketUpdateNotification::encode, PacketUpdateNotification::decode, PacketUpdateNotification::handle);
        packetInstance.registerMessage(13, PacketAnvilField.class, PacketAnvilField::encode, PacketAnvilField::decode, PacketAnvilField::handle);
        packetInstance.registerMessage(14, PacketWitherParticles.class, PacketWitherParticles::encode, PacketWitherParticles::decode, PacketWitherParticles::handle);
        packetInstance.registerMessage(15, PacketFlameParticles.class, PacketFlameParticles::encode, PacketFlameParticles::decode, PacketFlameParticles::handle);
        enigmaticLogger.info("Registering triggers...");
        CriteriaTriggers.func_192118_a((ICriterionTrigger)UseUnholyGrailTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)BeheadingTrigger.INSTANCE);
        ObfuscatedFields.extractCommonFields();
        enigmaticLogger.info("Common setup phase finished successfully.");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        enigmaticLogger.info("Initializing client setup phase...");
        keybindHandler.registerKeybinds();
        ObfuscatedFields.extractClientFields();
        enigmaticLogger.info("Client setup phase finished successfully.");
    }

    private void intermodStuff(InterModEnqueueEvent event) {
        enigmaticLogger.info("Sending messages to Curios API...");
        SuperpositionHandler.registerCurioType("charm", 1, true, false, null);
        SuperpositionHandler.registerCurioType("ring", 2, false, false, null);
        SuperpositionHandler.registerCurioType("spellstone", 1, false, false, new ResourceLocation(MODID, "slots/empty_spellstone_slot"));
        SuperpositionHandler.registerCurioType("scroll", 1, false, false, new ResourceLocation(MODID, "slots/empty_scroll_slot"));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onColorInit(ColorHandlerEvent.Item event) {
        enigmaticLogger.info("Initializing colors registration...");
        event.getItemColors().func_199877_a((stack, color) -> {
            if (PotionHelper.isAdvancedPotion(stack)) {
                return color > 0 ? -1 : PotionHelper.getColor(stack);
            }
            return color > 0 ? -1 : PotionUtils.func_190932_c((ItemStack)stack);
        }, new IItemProvider[]{ultimatePotionBase, ultimatePotionSplash, ultimatePotionLingering, commonPotionBase, commonPotionSplash, commonPotionLingering});
        enigmaticLogger.info("Colors registered successfully.");
    }

    static {
        enigmaticLogger = LogManager.getLogger((String)NAME);
        butImAsGuiltyAsThe = new OneSpecialHandler();
        damageTypesFire = new ArrayList<String>();
        ultimatePotionTypes = new ArrayList<AdvancedPotion>();
        commonPotionTypes = new ArrayList<AdvancedPotion>();
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        enigmaticTab = new ItemGroup("enigmaticCreativeTab"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)enigmaticItem);
            }
        };
        enigmaticPotionTab = new ItemGroup("enigmaticPotionCreativeTab"){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)recallPotion);
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="enigmaticlegacy")
    public static class RegistryEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void stitchTextures(TextureStitchEvent.Pre evt) {
            if (evt.getMap().func_229223_g_() == PlayerContainer.field_226615_c_) {
                evt.addSprite(new ResourceLocation(EnigmaticLegacy.MODID, "slots/empty_spellstone_slot"));
                evt.addSprite(new ResourceLocation(EnigmaticLegacy.MODID, "slots/empty_scroll_slot"));
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            enigmaticLogger.info("Initializing items registration...");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{enigmaticItem, golemHeart, angelBlessing, oceanStone, magmaHeart, eyeOfNebula, voidPearl, ironRing, enigmaticAmulet, thiccScroll, xpScroll, escapeScroll, heavenScroll, magnetRing, superMagnetRing, enderRing, monsterCharm, miningCharm, megaSponge, extradimensionalEye, forbiddenAxe, unholyGrail, recallPotion, mendingMixture, lootGenerator, hastePotionDefault, hastePotionExtended, hastePotionEmpowered, hastePotionExtendedEmpowered, relicOfTesting, etheriumOre, etheriumIngot, commonPotionBase, commonPotionSplash, commonPotionLingering, ultimatePotionBase, ultimatePotionSplash, ultimatePotionLingering, etheriumHelmet, etheriumChestplate, etheriumLeggings, etheriumBoots, etheriumPickaxe, etheriumAxe, etheriumShovel, etheriumSword, etheriumScythe, astralBreaker, astralDust, enderRod, loreInscriber, loreFragment, oblivionStone, enchantmentTransposer});
            enigmaticLogger.info("Items registered successfully.");
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            enigmaticLogger.info("Initializing sounds registration...");
            HHON = SuperpositionHandler.registerSound("misc.hhon");
            HHOFF = SuperpositionHandler.registerSound("misc.hhoff");
            SHIELD_TRIGGER = SuperpositionHandler.registerSound("misc.shield_trigger");
            enigmaticLogger.info("Sounds registered successfully.");
        }

        @SubscribeEvent
        public static void onRecipeRegister(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        }

        @SubscribeEvent
        public static void registerBrewing(RegistryEvent.Register<Potion> event) {
            enigmaticLogger.info("Initializing advanced potion system...");
            ULTIMATE_NIGHT_VISION = new AdvancedPotion("ultimate_night_vision", new EffectInstance(Effects.field_76439_r, 19200));
            ULTIMATE_INVISIBILITY = new AdvancedPotion("ultimate_invisibility", new EffectInstance(Effects.field_76441_p, 19200));
            ULTIMATE_LEAPING = new AdvancedPotion("ultimate_leaping", new EffectInstance(Effects.field_76430_j, 9600, 1));
            ULTIMATE_FIRE_RESISTANCE = new AdvancedPotion("ultimate_fire_resistance", new EffectInstance(Effects.field_76426_n, 19200));
            ULTIMATE_SWIFTNESS = new AdvancedPotion("ultimate_swiftness", new EffectInstance(Effects.field_76424_c, 9600, 1));
            ULTIMATE_SLOWNESS = new AdvancedPotion("ultimate_slowness", new EffectInstance(Effects.field_76421_d, 1200, 3));
            ULTIMATE_TURTLE_MASTER = new AdvancedPotion("ultimate_turtle_master", new EffectInstance(Effects.field_76421_d, 800, 5), new EffectInstance(Effects.field_76429_m, 800, 3));
            ULTIMATE_WATER_BREATHING = new AdvancedPotion("ultimate_water_breathing", new EffectInstance(Effects.field_76427_o, 19200));
            ULTIMATE_HEALING = new AdvancedPotion("ultimate_healing", new EffectInstance(Effects.field_76432_h, 1, 2));
            ULTIMATE_HARMING = new AdvancedPotion("ultimate_harming", new EffectInstance(Effects.field_76433_i, 1, 2));
            ULTIMATE_POISON = new AdvancedPotion("ultimate_poison", new EffectInstance(Effects.field_76436_u, 1800, 1));
            ULTIMATE_REGENERATION = new AdvancedPotion("ultimate_regeneration", new EffectInstance(Effects.field_76428_l, 1800, 1));
            ULTIMATE_STRENGTH = new AdvancedPotion("ultimate_strength", new EffectInstance(Effects.field_76420_g, 9600, 1));
            ULTIMATE_WEAKNESS = new AdvancedPotion("ultimate_weakness", new EffectInstance(Effects.field_76437_t, 9600));
            ULTIMATE_SLOW_FALLING = new AdvancedPotion("ultimate_slow_falling", new EffectInstance(Effects.field_204839_B, 9600));
            HASTE = new AdvancedPotion("haste", new EffectInstance(Effects.field_76422_e, 3600));
            LONG_HASTE = new AdvancedPotion("long_haste", new EffectInstance(Effects.field_76422_e, 9600));
            STRONG_HASTE = new AdvancedPotion("strong_haste", new EffectInstance(Effects.field_76422_e, 1800, 1));
            ULTIMATE_HASTE = new AdvancedPotion("ultimate_haste", new EffectInstance(Effects.field_76422_e, 9600, 1));
            EMPTY = new AdvancedPotion("empty", new EffectInstance[0]);
            ultimatePotionTypes.add(ULTIMATE_NIGHT_VISION);
            ultimatePotionTypes.add(ULTIMATE_INVISIBILITY);
            ultimatePotionTypes.add(ULTIMATE_LEAPING);
            ultimatePotionTypes.add(ULTIMATE_FIRE_RESISTANCE);
            ultimatePotionTypes.add(ULTIMATE_SWIFTNESS);
            ultimatePotionTypes.add(ULTIMATE_SLOWNESS);
            ultimatePotionTypes.add(ULTIMATE_TURTLE_MASTER);
            ultimatePotionTypes.add(ULTIMATE_WATER_BREATHING);
            ultimatePotionTypes.add(ULTIMATE_HEALING);
            ultimatePotionTypes.add(ULTIMATE_HARMING);
            ultimatePotionTypes.add(ULTIMATE_POISON);
            ultimatePotionTypes.add(ULTIMATE_REGENERATION);
            ultimatePotionTypes.add(ULTIMATE_STRENGTH);
            ultimatePotionTypes.add(ULTIMATE_WEAKNESS);
            ultimatePotionTypes.add(ULTIMATE_SLOW_FALLING);
            commonPotionTypes.add(HASTE);
            commonPotionTypes.add(LONG_HASTE);
            commonPotionTypes.add(STRONG_HASTE);
            ultimatePotionTypes.add(ULTIMATE_HASTE);
            enigmaticLogger.info("Advanced potion system initialized successfully.");
        }

        @SubscribeEvent
        public static void onEntitiesRegistry(RegistryEvent.Register<EntityType<?>> event) {
            enigmaticLogger.info("Initializing entities registration...");
            event.getRegistry().register(EntityType.Builder.func_220322_a(PermanentItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new PermanentItemEntity(PermanentItemEntity.TYPE, (World)world)).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true).func_206830_a("").setRegistryName(new ResourceLocation(EnigmaticLegacy.MODID, "permanent_item_entity")));
            event.getRegistry().register(EntityType.Builder.func_220322_a(EnigmaticPotionEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new EnigmaticPotionEntity(EnigmaticPotionEntity.TYPE, (World)world)).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true).func_206830_a("").setRegistryName(new ResourceLocation(EnigmaticLegacy.MODID, "enigmatic_potion_entity")));
            event.getRegistry().register(EntityType.Builder.func_220322_a(UltimateWitherSkullEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new UltimateWitherSkullEntity((EntityType<? extends UltimateWitherSkullEntity>)UltimateWitherSkullEntity.TYPE, (World)world)).func_206830_a("").setRegistryName(new ResourceLocation(EnigmaticLegacy.MODID, "ultimate_wither_skull_entity")));
            enigmaticLogger.info("Entities registered successfully.");
        }
    }
}

