/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.entities;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.objects.WitherExplosion;
import com.integral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;

public class UltimateWitherSkullEntity
extends DamagingProjectileEntity {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(UltimateWitherSkullEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOUND_TARGET = EntityDataManager.func_187226_a(UltimateWitherSkullEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    int targetID;
    LivingEntity target;
    @ObjectHolder(value="enigmaticlegacy:ultimate_wither_skull_entity")
    public static EntityType<UltimateWitherSkullEntity> TYPE;

    public UltimateWitherSkullEntity(EntityType<? extends UltimateWitherSkullEntity> p_i50147_1_, World p_i50147_2_) {
        super(p_i50147_1_, p_i50147_2_);
        this.targetID = -1;
        this.target = null;
    }

    public UltimateWitherSkullEntity(World worldIn, LivingEntity shooter) {
        super(TYPE, shooter, 0.0, 0.0, 0.0, worldIn);
        this.field_70232_b = 0.0;
        this.field_70233_c = 0.0;
        this.field_70230_d = 0.0;
        this.targetID = -1;
        this.target = null;
        this.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
    }

    public UltimateWitherSkullEntity(World worldIn, LivingEntity shooter, LivingEntity target) {
        this(worldIn, shooter);
        this.target = target;
        this.targetID = target.func_145782_y();
        this.field_70180_af.func_187227_b(BOUND_TARGET, (Object)this.targetID);
    }

    public void initMotion(LivingEntity player, double accelX, double accelY, double accelZ, float modifier) {
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        double d0 = MathHelper.func_76133_a((double)((accelX += this.field_70146_Z.nextGaussian() * 0.4) * accelX + (accelY += this.field_70146_Z.nextGaussian() * 0.4) * accelY + (accelZ += this.field_70146_Z.nextGaussian() * 0.4) * accelZ));
        this.field_70232_b = accelX / d0 * 0.1;
        this.field_70233_c = accelY / d0 * 0.1;
        this.field_70230_d = accelZ / d0 * 0.1;
        this.field_70232_b *= (double)modifier;
        this.field_70233_c *= (double)modifier;
        this.field_70230_d *= (double)modifier;
    }

    protected float func_82341_c() {
        return super.func_82341_c();
    }

    public boolean func_70027_ad() {
        return false;
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, IFluidState p_180428_5_, float p_180428_6_) {
        return this.isSkullInvulnerable() && !BlockTags.field_219755_X.func_199685_a_((Object)blockStateIn.func_177230_c()) ? Math.min(0.8f, p_180428_6_) : p_180428_6_;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 10 && this.field_70173_aa < 400) {
            int targetId;
            if (this.target == null && (targetId = ((Integer)this.field_70180_af.func_187225_a(BOUND_TARGET)).intValue()) != -1) {
                try {
                    this.target = (LivingEntity)this.field_70170_p.func_73045_a(targetId);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.target != null && this.target.func_70089_S()) {
                Vector3 thisVec = Vector3.fromEntityCenter((Entity)this);
                Vector3 targetVec = Vector3.fromEntityCenter((Entity)this.target);
                Vector3 diffVec = targetVec.subtract(thisVec);
                Vector3 motionVec = diffVec.normalize().multiply(0.6);
                double distance = this.func_70032_d((Entity)this.target);
                Vector3 formerMotion = new Vector3(this.func_213322_ci()).multiply(0.6);
                if (distance < 6.0 && distance != 0.0) {
                    this.func_213317_d(new Vec3d(formerMotion.x + motionVec.x * 2.0 / distance, formerMotion.y + motionVec.y * 2.0 / distance, formerMotion.z + motionVec.z * 2.0 / distance).func_72432_b().func_216372_d(1.4, 1.4, 1.4));
                }
                this.field_70232_b = motionVec.x / 3.0;
                this.field_70233_c = motionVec.y / 3.0;
                this.field_70230_d = motionVec.z / 3.0;
            }
        }
        if (this.field_70170_p.field_72995_K || this.field_70235_a == null) {
            return;
        }
        if (this.field_70173_aa < 10) {
            Vector3 res = AOEMiningHelper.calcRayTrace(this.field_70170_p, (PlayerEntity)this.field_70235_a, RayTraceContext.FluidMode.NONE, 128.0);
            this.initMotion(this.field_70235_a, res.x - this.func_226277_ct_(), res.y - this.func_226278_cu_(), res.z - this.func_226281_cx_(), 0.1f);
            return;
        }
        if (this.field_70173_aa == 10) {
            Vector3 res = AOEMiningHelper.calcRayTrace(this.field_70170_p, (PlayerEntity)this.field_70235_a, RayTraceContext.FluidMode.NONE, 128.0);
            this.initMotion(this.field_70235_a, res.x - this.func_226277_ct_(), res.y - this.func_226278_cu_(), res.z - this.func_226281_cx_(), 1.5f);
        } else if (this.field_70173_aa >= 400) {
            this.func_70227_a((RayTraceResult)BlockRayTraceResult.func_216352_a((Vec3d)this.func_174791_d(), (Direction)Direction.DOWN, (BlockPos)this.func_180425_c()));
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.clearInvincibility();
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                if (entity == this.field_70235_a) {
                    return;
                }
                if (this.field_70235_a != null) {
                    if (entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70235_a), this.isSkullInvulnerable() ? 24.0f : 8.0f) && entity.func_70089_S()) {
                        this.func_174815_a(this.field_70235_a, entity);
                    }
                } else {
                    entity.func_70097_a(DamageSource.field_76376_m, this.isSkullInvulnerable() ? 16.0f : 5.0f);
                }
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, 600, 1));
                }
            }
            float explosionRadius = this.isSkullInvulnerable() ? 1.5f : 1.0f;
            WitherExplosion explosion = new WitherExplosion(this.field_70170_p, (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), explosionRadius, false, Explosion.Mode.DESTROY);
            if (!ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                explosion.func_77278_a();
                explosion.func_77279_a(true);
                for (ServerPlayerEntity serverplayerentity : this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_201675_m().func_186058_p()).func_217369_A()) {
                    if (!(serverplayerentity.func_70092_e(explosion.getPosition().field_72450_a, explosion.getPosition().field_72448_b, explosion.getPosition().field_72449_c) < 4096.0)) continue;
                    serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(explosion.getPosition().field_72450_a, explosion.getPosition().field_72448_b, explosion.getPosition().field_72449_c, explosionRadius, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(serverplayerentity)));
                }
            }
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 64.0, this.field_71093_bK)), (Object)new PacketWitherParticles(this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), this.isSkullInvulnerable() ? 20 : 16, false));
            this.func_70106_y();
        }
    }

    public void clearInvincibility() {
        List entities = this.field_70170_p.func_217357_a(LivingEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)this, 3.0));
        for (LivingEntity entity : entities) {
            entity.field_70172_ad = 0;
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
        this.field_70180_af.func_187214_a(BOUND_TARGET, (Object)-1);
    }

    public boolean isSkullInvulnerable() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void setSkullInvulnerable(boolean invulnerable) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)invulnerable);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

