/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.PermanentItemEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.ObfuscatedFields;
import com.integral.enigmaticlegacy.helpers.PotionHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import com.integral.enigmaticlegacy.objects.CooldownMap;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketSlotUnlocked;
import com.integral.enigmaticlegacy.packets.server.PacketAnvilField;
import com.integral.enigmaticlegacy.triggers.BeheadingTrigger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;

@Mod.EventBusSubscriber(modid="enigmaticlegacy")
public class EnigmaticEventHandler {
    private static final String NBT_KEY_FIRSTJOIN = "enigmaticlegacy.firstjoin";
    private static final String NBT_KEY_ENABLESPELLSTONE = "enigmaticlegacy.spellstones_enabled";
    private static final String NBT_KEY_ENABLERING = "enigmaticlegacy.rings_enabled";
    private static final String NBT_KEY_ENABLESCROLL = "enigmaticlegacy.scrolls_enabled";
    public static CooldownMap deferredToast = new CooldownMap();
    public static List<IToast> scheduledToasts = new ArrayList<IToast>();
    public static Random theySeeMeRollin = new Random();
    public static HashMap<PlayerEntity, String> anvilFields = new HashMap();

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onEntityTick(TickEvent.ClientTickEvent event) {
        try {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            deferredToast.tick((LivingEntity)player);
            if (deferredToast.getCooldown((LivingEntity)player) == 1) {
                Minecraft.func_71410_x().func_193033_an().func_192988_a(scheduledToasts.get(0));
                scheduledToasts.remove(0);
                if (scheduledToasts.size() > 0) {
                    deferredToast.put(player, 5);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLooting(LootingLevelEvent event) {
        PlayerEntity player;
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(player = (PlayerEntity)event.getDamageSource().func_76346_g()), EnigmaticLegacy.monsterCharm) && ConfigHandler.MONSTER_CHARM_BONUS_LOOTING.getValue()) {
            event.setLootingLevel(event.getLootingLevel() + 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        PlayerEntity player = event.getAttackingPlayer();
        if (event.getEntityLiving() instanceof MonsterEntity && player != null && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.monsterCharm)) {
            event.setDroppedExperience((int)((float)event.getDroppedExperience() * EnigmaticLegacy.monsterCharm.bonusXPModifier));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void miningStuff(PlayerEvent.BreakSpeed event) {
        float miningBoost = 1.0f;
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.miningCharm)) {
            miningBoost += ConfigHandler.MINING_CHARM_BREAK_BOOST.getValue().asModifier(false);
        }
        if (!event.getPlayer().field_70122_E && (SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.heavenScroll) || SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.enigmaticItem))) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
        event.setNewSpeed(event.getNewSpeed() * miningBoost);
    }

    @SubscribeEvent
    public void onBlockDropsHarvest(BlockEvent.HarvestDropsEvent event) {
    }

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            ArrayList effects;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.magmaHeart) && !player.func_70651_bq().isEmpty()) {
                effects = player.func_70651_bq();
                for (EffectInstance effect : effects) {
                    effect.func_76455_a((LivingEntity)player, () -> {});
                }
            }
            if (EnigmaticLegacy.etheriumChestplate.hasShield(player) && !player.func_70651_bq().isEmpty()) {
                effects = new ArrayList(player.func_70651_bq());
                for (EffectInstance effect : effects) {
                    if (effect.func_188419_a().func_188408_i()) continue;
                    player.func_195063_d(effect.func_188419_a());
                }
            }
            if (event.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            if (SuperpositionHandler.hasSpellstoneCooldown(player)) {
                SuperpositionHandler.setSpellstoneCooldown(player, SuperpositionHandler.getSpellstoneCooldown(player) - 1);
            }
            EnigmaticLegacy.etheriumSword.etheriumSwordCooldowns.tick((LivingEntity)player);
            EnigmaticLegacy.enigmaticItem.handleEnigmaticFlight(player);
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.func_77973_b() instanceof ICurio && stack.func_77973_b().getRegistryName().func_110624_b().equals("enigmaticlegacy")) {
            final ICurio curioCapabilities = (ICurio)stack.func_77973_b();
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                LazyOptional<ICurio> curio = LazyOptional.of(() -> curioCapabilities);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onConfirmedDeath(LivingDeathEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(player = (PlayerEntity)event.getEntityLiving()), EnigmaticLegacy.escapeScroll) & !player.field_70170_p.field_72995_K) {
            ItemStack tomeStack = SuperpositionHandler.getCurioStack((LivingEntity)player, EnigmaticLegacy.escapeScroll);
            PermanentItemEntity droppedTomeStack = new PermanentItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), tomeStack.func_77946_l());
            droppedTomeStack.setPickupDelay(10);
            player.field_70170_p.func_217376_c((Entity)droppedTomeStack);
            tomeStack.func_190918_g(1);
            Vec3d vec = SuperpositionHandler.getValidSpawn(player.field_70170_p, player);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1024.0, player.field_71093_bK)), (Object)new PacketPortalParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 72, 1.0, false));
            player.func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1024.0, player.field_71093_bK)), (Object)new PacketRecallParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 48, false));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity & !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.enigmaticItem) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)EnigmaticLegacy.enigmaticItem))) {
                event.setCanceled(true);
                player.func_70606_j(1.0f);
            } else if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.voidPearl) && Math.random() <= ConfigHandler.VOID_PEARL_UNDEAD_PROBABILITY.getValue().asMultiplier(false)) {
                event.setCanceled(true);
                player.func_70606_j(1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(player = (PlayerEntity)event.getEntityLiving()), EnigmaticLegacy.voidPearl) && event.getAmount() <= 1.0f) {
            event.setAmount((float)((double)event.getAmount() / (1.5 * ConfigHandler.VOID_PEARL_REGENERATION_MODIFIER.getValue())));
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            List<ItemStack> advancedCurios;
            PlayerEntity player2 = (PlayerEntity)event.getEntityLiving();
            if (EnigmaticLegacy.etheriumChestplate.hasShield(player2) && (event.getSource().func_76364_f() instanceof DamagingProjectileEntity || event.getSource().func_76364_f() instanceof AbstractArrowEntity)) {
                event.setCanceled(true);
                player2.field_70170_p.func_184133_a(null, player2.func_180425_c(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                player2.field_70170_p.func_184133_a(null, player2.func_180425_c(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
            }
            if ((advancedCurios = SuperpositionHandler.getAdvancedCurios((LivingEntity)player2)).size() > 0) {
                for (ItemStack advancedCurioStack : advancedCurios) {
                    ItemAdvancedCurio advancedCurio = (ItemAdvancedCurio)advancedCurioStack.func_77973_b();
                    if (advancedCurio.immunityList.contains(event.getSource().field_76373_n)) {
                        event.setCanceled(true);
                    }
                    if (advancedCurio != EnigmaticLegacy.voidPearl || !EnigmaticLegacy.voidPearl.healList.contains(event.getSource().field_76373_n)) continue;
                    player2.func_70691_i(event.getAmount());
                    event.setCanceled(true);
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player2, EnigmaticLegacy.eyeOfNebula) && !event.isCanceled() && Math.random() <= ConfigHandler.EYE_OF_NEBULA_DODGE_PROBABILITY.getValue().asMultiplier(false) && player2.field_70172_ad <= 10 && event.getSource().func_76346_g() instanceof LivingEntity) {
                for (int counter = 0; counter <= 32 && !SuperpositionHandler.validTeleportRandomly((Entity)player2, player2.field_70170_p, (int)ConfigHandler.EYE_OF_NEBULA_DODGE_RANGE.getValue()); ++counter) {
                }
                player2.field_70172_ad = 20;
                event.setCanceled(true);
            }
        } else if (event.getSource().func_76364_f() instanceof PlayerEntity && (player = (PlayerEntity)event.getSource().func_76364_f()).func_184614_ca() != null && player.func_184614_ca().func_77973_b() == EnigmaticLegacy.extradimensionalEye && ItemNBTHelper.verifyExistance(player.func_184614_ca(), "BoundDimension") && ItemNBTHelper.getInt(player.func_184614_ca(), "BoundDimension", 0) == event.getEntityLiving().field_71093_bK.func_186068_a()) {
            event.setCanceled(true);
            ItemStack stack = player.func_184614_ca();
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), 128.0, event.getEntityLiving().field_71093_bK)), (Object)new PacketPortalParticles(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + (double)(event.getEntityLiving().func_213302_cg() / 2.0f), event.getEntityLiving().func_226281_cx_(), 96, 1.5, false));
            event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            event.getEntityLiving().func_70634_a(ItemNBTHelper.getDouble(stack, "BoundX", 0.0), ItemNBTHelper.getDouble(stack, "BoundY", 0.0), ItemNBTHelper.getDouble(stack, "BoundZ", 0.0));
            event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), 128.0, event.getEntityLiving().field_71093_bK)), (Object)new PacketRecallParticles(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + (double)(event.getEntityLiving().func_213302_cg() / 2.0f), event.getEntityLiving().func_226281_cx_(), 48, false));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity & !event.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity attacker;
            player = (PlayerEntity)event.getEntityLiving();
            List<ItemStack> advancedCurios = SuperpositionHandler.getAdvancedCurios((LivingEntity)player);
            if (advancedCurios.size() > 0) {
                for (ItemStack advancedCurioStack : advancedCurios) {
                    Entity attacker2;
                    ItemAdvancedCurio advancedCurio = (ItemAdvancedCurio)advancedCurioStack.func_77973_b();
                    if (advancedCurio.resistanceList.containsKey(event.getSource().field_76373_n)) {
                        event.setAmount(event.getAmount() * advancedCurio.resistanceList.get(event.getSource().field_76373_n).get().floatValue());
                    }
                    if (advancedCurio != EnigmaticLegacy.oceanStone || !((attacker2 = event.getSource().func_76346_g()) instanceof DrownedEntity) && !(attacker2 instanceof GuardianEntity) && !(attacker2 instanceof ElderGuardianEntity)) continue;
                    event.setAmount(event.getAmount() * ConfigHandler.OCEAN_STONE_UNDERWATER_CREATURES_RESISTANCE.getValue().asModifierInverted());
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.magmaHeart) && event.getSource().func_76346_g() instanceof LivingEntity && EnigmaticLegacy.magmaHeart.nemesisList.contains(event.getSource().field_76373_n) && !(attacker = (LivingEntity)event.getSource().func_76346_g()).func_70045_F()) {
                attacker.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76370_b.field_76373_n, (Entity)player), (float)ConfigHandler.BLAZING_CORE_DAMAGE_FEEDBACK.getValue());
                attacker.func_70015_d(ConfigHandler.BLAZING_CORE_IGNITION_FEEDBACK.getValue());
            }
            if (EnigmaticLegacy.etheriumChestplate.hasShield(player)) {
                if (event.getSource().func_76364_f() instanceof LivingEntity) {
                    attacker = (LivingEntity)event.getSource().func_76346_g();
                    Vector3 vec = Vector3.fromEntityCenter((Entity)player).subtract(Vector3.fromEntityCenter(event.getSource().func_76346_g())).normalize();
                    attacker.func_70653_a((Entity)player, 0.75f, vec.x, vec.y);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                }
                event.setAmount(event.getAmount() * ConfigHandler.ETHERIUM_ARMOR_SHIELD_REDUCTION.getValue().asModifierInverted());
            }
        } else if (event.getEntityLiving() instanceof MonsterEntity) {
            MonsterEntity monster = (MonsterEntity)event.getEntityLiving();
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player2 = (PlayerEntity)event.getSource().func_76346_g();
                if (SuperpositionHandler.hasCurio((LivingEntity)player2, EnigmaticLegacy.monsterCharm)) {
                    if (monster.func_70662_br()) {
                        event.setAmount(event.getAmount() * ConfigHandler.MONSTER_CHARM_UNDEAD_DAMAGE.getValue().asModifier(true));
                    } else if (!(!monster.func_213398_dR() && !(monster instanceof CreeperEntity) || monster instanceof EndermanEntity || monster instanceof ZombiePigmanEntity || monster instanceof BlazeEntity || monster instanceof GuardianEntity || monster instanceof ElderGuardianEntity || !monster.func_184222_aU())) {
                        event.setAmount(event.getAmount() * ConfigHandler.MONSTER_CHARM_AGGRESSIVE_DAMAGE.getValue().asModifier(true));
                    }
                }
                if (monster instanceof CreeperEntity) {
                    monster.func_130011_c((Entity)player2);
                }
            }
        }
        if (event.getSource().func_76346_g() instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(player = (PlayerEntity)event.getSource().func_76346_g()), EnigmaticLegacy.voidPearl)) {
            event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, ConfigHandler.VOID_PEARL_WITHERING_EFFECT_TIME.getValue(), ConfigHandler.VOID_PEARL_WITHERING_EFFECT_LEVEL.getValue(), false, true));
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        ItemStack weap;
        if (event.getEntityLiving().getClass() == SkeletonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            ItemStack weap2 = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap2 != null && weap2.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !this.containsDrop(event.getDrops(), Items.field_196182_dv) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196182_dv, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == WitherSkeletonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            ItemStack weap3 = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap3 != null && weap3.func_77973_b() == EnigmaticLegacy.forbiddenAxe) {
                if (!this.containsDrop(event.getDrops(), Items.field_196183_dw) && this.theySeeMeRollin(event.getLootingLevel())) {
                    this.addDrop(event, new ItemStack((IItemProvider)Items.field_196183_dw, 1));
                }
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && this.containsDrop(event.getDrops(), Items.field_196183_dw)) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == ZombieEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            ItemStack weap4 = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap4 != null && weap4.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !this.containsDrop(event.getDrops(), Items.field_196186_dz) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196186_dz, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == CreeperEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            ItemStack weap5 = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap5 != null && weap5.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !this.containsDrop(event.getDrops(), Items.field_196185_dy) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196185_dy, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == EnderDragonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity && (weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca()) != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !this.containsDrop(event.getDrops(), Items.field_196151_dA) && this.theySeeMeRollin(event.getLootingLevel())) {
            this.addDrop(event, new ItemStack((IItemProvider)Items.field_196151_dA, 1));
            if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTablesLoaded(LootTableLoadEvent event) {
        LootPool special;
        LootPool epic;
        LootTable modified;
        LootPool poolSpellstones;
        ArrayList<ResourceLocation> underwaterRuins = new ArrayList<ResourceLocation>();
        underwaterRuins.add(LootTables.field_204115_q);
        underwaterRuins.add(LootTables.field_204114_p);
        if (SuperpositionHandler.getMergedAir$EarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -8.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 35), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.angelBlessing, 65)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getMergedEnder$EarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -4.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.eyeOfNebula, 35), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 65)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getAirDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -4.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.angelBlessing, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getEarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -8.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getFieryDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -12.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.magmaHeart, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getWaterDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -7.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.oceanStone, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getEnderDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -7.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.eyeOfNebula, 90), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.voidPearl, 10)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperpositionHandler.getOverworldDungeons().contains(event.getName())) {
            epic = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.itemEntryBuilderED(Items.field_151035_b, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151036_c, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151040_l, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151037_a, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151031_f, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.ironRing, 20), ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.commonPotionBase).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE).func_77978_p())), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.magnetRing, 8), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.unholyGrail, 4), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.loreInscriber, 5), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151113_aN).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151111_aL).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151123_aH).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)10.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_216086_a(35).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151158_bO).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)16.0f)))});
            modified = event.getTable();
            modified.addPool(epic);
            event.setTable(modified);
        } else if (event.getName().equals((Object)LootTables.field_186425_g)) {
            ItemStack fireResistancePotion = new ItemStack((IItemProvider)Items.field_151068_bn);
            fireResistancePotion = PotionUtils.func_185188_a((ItemStack)fireResistancePotion, (Potion)Potions.field_185242_n);
            LootPool epic2 = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.itemEntryBuilderED(Items.field_151005_D, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151006_E, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151010_B, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151011_C, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.oblivionStone, 8), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)7.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_221690_bg).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151073_bk).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151129_at).func_216086_a(30), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151068_bn).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)fireResistancePotion.func_77978_p()))});
            LootTable modified2 = event.getTable();
            modified2.addPool(epic2);
            event.setTable(modified2);
        } else if (event.getName().equals((Object)LootTables.field_186421_c)) {
            epic = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)Items.field_151079_bi).func_216086_a(40).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151061_bv).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151060_bw).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151150_bK).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_204840_eX).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_221824_dv).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_222070_lD).func_216086_a(15), ItemLootEntry.func_216168_a((IItemProvider)Items.field_185158_cP).func_216086_a(7), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.loreInscriber, 10), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.recallPotion, 15), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.mendingMixture, 40), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.astralDust, 85, 1.0f, 4.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.etheriumOre, 60, 1.0f, 2.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.extradimensionalEye, 20)});
            modified = event.getTable();
            modified.addPool(epic);
            event.setTable(modified);
        }
        if (event.getName().equals((Object)LootTables.field_186426_h)) {
            special = SuperpositionHandler.constructLootPool("el_special", 2.0f, 2.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.thiccScroll).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)6.0f))), ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.loreFragment).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))});
            modified = event.getTable();
            modified.addPool(special);
            event.setTable(modified);
        }
        if (event.getName().equals((Object)LootTables.field_204115_q) || event.getName().equals((Object)LootTables.field_204114_p)) {
            special = SuperpositionHandler.constructLootPool("el_special", -5.0f, 1.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)Items.field_203184_eO).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.5f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)15.0f, (float)40.0f)).func_216059_e())});
            modified = event.getTable();
            modified.addPool(special);
            event.setTable(modified);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        try {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (!SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_FIRSTJOIN)) {
                ItemStack stack = new ItemStack((IItemProvider)EnigmaticLegacy.enigmaticAmulet);
                ItemNBTHelper.setString(stack, "Inscription", player.func_145748_c_().getString());
                if (player.field_71071_by.func_70301_a(8).func_190926_b()) {
                    player.field_71071_by.func_70299_a(8, stack);
                } else if (!player.field_71071_by.func_70441_a(stack)) {
                    ItemEntity dropIt = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                    player.field_70170_p.func_217376_c((Entity)dropIt);
                }
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_FIRSTJOIN, true);
            }
            if (!SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_ENABLESPELLSTONE) && SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "main/discover_spellstone"))) {
                CuriosAPI.enableTypeForEntity((String)"spellstone", (LivingEntity)event.getPlayer());
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_ENABLESPELLSTONE, true);
            }
            if (!SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_ENABLESCROLL) && SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "main/discover_spellstone"))) {
                CuriosAPI.enableTypeForEntity((String)"scroll", (LivingEntity)event.getPlayer());
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_ENABLESCROLL, true);
            }
            if (!SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_ENABLERING) && SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "main/discover_spellstone"))) {
                CuriosAPI.enableTypeForEntity((String)"ring", (LivingEntity)event.getPlayer());
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_ENABLERING, true);
            }
        }
        catch (Exception ex) {
            EnigmaticLegacy.enigmaticLogger.error("Failed to check player's advancements upon joining the world!");
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onAdvancement(AdvancementEvent event) {
        String id = event.getAdvancement().func_192067_g().toString();
        PlayerEntity player = event.getPlayer();
        if (id.equals("enigmaticlegacy:main/discover_spellstone")) {
            CuriosAPI.enableTypeForEntity((String)"spellstone", (LivingEntity)player);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSlotUnlocked("spellstone"));
            SuperpositionHandler.setPersistentBoolean(player, NBT_KEY_ENABLESPELLSTONE, true);
        } else if (id.equals("enigmaticlegacy:main/discover_scroll")) {
            CuriosAPI.enableTypeForEntity((String)"scroll", (LivingEntity)player);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSlotUnlocked("scroll"));
            SuperpositionHandler.setPersistentBoolean(player, NBT_KEY_ENABLESCROLL, true);
        } else if (id.equals("enigmaticlegacy:main/discover_ring")) {
            CuriosAPI.enableTypeForEntity((String)"ring", (LivingEntity)player);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSlotUnlocked("ring"));
            SuperpositionHandler.setPersistentBoolean(player, NBT_KEY_ENABLERING, true);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player.field_70170_p.field_72995_K || event.isEndConquered() || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c))) {
            if (SuperpositionHandler.hasPersistentTag(player, NBT_KEY_ENABLERING)) {
                CuriosAPI.enableTypeForEntity((String)"ring", (LivingEntity)event.getPlayer());
            }
            if (SuperpositionHandler.hasPersistentTag(player, NBT_KEY_ENABLESCROLL)) {
                CuriosAPI.enableTypeForEntity((String)"scroll", (LivingEntity)event.getPlayer());
            }
            if (SuperpositionHandler.hasPersistentTag(player, NBT_KEY_ENABLESPELLSTONE)) {
                CuriosAPI.enableTypeForEntity((String)"spellstone", (LivingEntity)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onAnvilOpen(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof AnvilScreen) {
            AnvilScreen screen = (AnvilScreen)event.getGui();
            EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketAnvilField(""));
            try {
                for (Field f : screen.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (!(f.get(screen) instanceof TextFieldWidget)) continue;
                    TextFieldWidget widget = (TextFieldWidget)f.get(screen);
                    widget.func_146203_f(64);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldCreation(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof CreateWorldScreen) {
            CreateWorldScreen screen = (CreateWorldScreen)event.getGui();
            try {
                String localizedWorld = I18n.func_135052_a((String)"world.enigmaticlegacy.name", (Object[])new Object[0]);
                String number = SuperpositionHandler.generateRandomWorldNumber();
                String name = localizedWorld + number;
                ObfuscatedFields.worldNameField.set(screen, name);
                ObfuscatedFields.worldSeedField.set(screen, number);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        if (!SuperpositionHandler.hasStoredAnvilField(event.getPlayer()) || event.getPlayer().field_70170_p.field_72995_K || event.getItemInput().func_77973_b() != EnigmaticLegacy.loreFragment || event.getIngredientInput().func_77973_b() != EnigmaticLegacy.loreInscriber) {
            return;
        }
        ItemLoreHelper.AnvilParser parser = ItemLoreHelper.AnvilParser.parseField(anvilFields.get(event.getPlayer()));
        if (!parser.getFormattedString().equals("") && !parser.shouldRemoveString()) {
            if (parser.isLoreString()) {
                if (parser.getLoreIndex() != -1) {
                    ItemLoreHelper.setLoreString(event.getItemResult(), parser.getFormattedString(), parser.getLoreIndex());
                } else {
                    ItemLoreHelper.setLastLoreString(event.getItemResult(), parser.getFormattedString());
                }
            } else {
                ItemLoreHelper.setDisplayName(event.getItemResult(), parser.getFormattedString());
            }
        }
        event.setBreakChance(0.01f);
        event.getPlayer().func_191521_c(event.getIngredientInput().func_77946_l());
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().func_190916_E() == 1) {
            if (event.getLeft().func_77973_b().equals(EnigmaticLegacy.loreFragment) && event.getRight().func_77973_b().equals(EnigmaticLegacy.loreInscriber) && event.getName() != null) {
                ItemStack returned = event.getLeft().func_77946_l();
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (!event.getName().equals(returned.func_200301_q().func_150254_d())) {
                        EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketAnvilField(event.getName()));
                    }
                });
                ItemLoreHelper.AnvilParser parser = ItemLoreHelper.AnvilParser.parseField(event.getName());
                if (!parser.getFormattedString().equals("") || parser.shouldRemoveString()) {
                    if (parser.isLoreString()) {
                        if (parser.getLoreIndex() != -1) {
                            ItemLoreHelper.setLoreString(returned, parser.getFormattedString(), parser.getLoreIndex());
                        } else {
                            ItemLoreHelper.addLoreString(returned, parser.getFormattedString());
                        }
                    } else if (parser.shouldRemoveString()) {
                        ItemLoreHelper.removeLoreString(returned, parser.getLoreIndex());
                    } else {
                        ItemLoreHelper.setDisplayName(returned, parser.getFormattedString());
                    }
                    event.setCost(1);
                    event.setMaterialCost(1);
                    event.setOutput(returned);
                }
            } else if (event.getRight().func_77973_b().equals(EnigmaticLegacy.loreFragment) && event.getRight().func_179543_a("display") != null) {
                event.setCost(4);
                event.setMaterialCost(1);
                event.setOutput(ItemLoreHelper.mergeDisplayData(event.getRight(), event.getLeft().func_77946_l()));
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() != null && !event.getPlayer().field_70170_p.field_72995_K && event.getInventory().func_213901_a((Item)EnigmaticLegacy.enchantmentTransposer) == 1 && event.getCrafting().func_77973_b() == Items.field_151134_bR) {
            event.getPlayer().field_70170_p.func_184133_a(null, event.getPlayer().func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 1.0f, (float)((double)0.9f + Math.random() * (double)0.1f));
        }
    }

    public void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), drop);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    public boolean containsDrop(Collection<ItemEntity> drops, Item item) {
        for (ItemEntity drop : drops) {
            if (drop.func_92059_d() == null || drop.func_92059_d().func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public boolean theySeeMeRollin(int lootingLevel) {
        double chance = ConfigHandler.FORBIDDEN_AXE_BEHEADING_BASE.getValue().asMultiplier(false) + ConfigHandler.FORBIDDEN_AXE_BEHEADING_BONUS.getValue().asMultiplier(false) * (double)lootingLevel;
        return Math.random() <= chance;
    }
}

