/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.google.common.collect.Lists;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;

public class SuperpositionHandler {
    public static final Random random = new Random();
    public static final char[] symbols = "abcdefghijklmnopqrstuvwxyz".toUpperCase().toCharArray();
    public static HashMap<PlayerEntity, Integer> spellstoneCooldowns = new HashMap();

    public static boolean hasAdvancedCurios(LivingEntity entity) {
        return SuperpositionHandler.getAdvancedCurios(entity).size() > 0;
    }

    public static List<ItemStack> getAdvancedCurios(LivingEntity entity) {
        ICurioItemHandler stackHandler = (ICurioItemHandler)CuriosAPI.getCuriosHandler((LivingEntity)entity).orElse(null);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (stackHandler != null) {
            for (String slotType : stackHandler.getCurioMap().keySet()) {
                CurioStackHandler handler = stackHandler.getStackHandler(slotType);
                for (int id = 0; id < handler.getSlots(); ++id) {
                    if (handler.getStackInSlot(id) == null || !(handler.getStackInSlot(id).func_77973_b() instanceof ItemAdvancedCurio)) continue;
                    stackList.add(handler.getStackInSlot(id));
                }
            }
        }
        return stackList;
    }

    public static boolean hasCurio(LivingEntity entity, Item curio) {
        Optional data = CuriosAPI.getCurioEquipped((Item)curio, (LivingEntity)entity);
        return data.isPresent();
    }

    @Nullable
    public static ItemStack getCurioStack(LivingEntity entity, Item curio) {
        Optional data = CuriosAPI.getCurioEquipped((Item)curio, (LivingEntity)entity);
        if (data.isPresent()) {
            return (ItemStack)((ImmutableTriple)data.get()).getRight();
        }
        return null;
    }

    public static void registerCurioType(String identifier, int slots, boolean isEnabled, boolean isHidden, @Nullable ResourceLocation icon) {
        CurioIMCMessage message = new CurioIMCMessage(identifier);
        message.setSize(slots);
        message.setEnabled(isEnabled);
        message.setHidden(isHidden);
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> message);
        if (icon != null) {
            InterModComms.sendTo((String)"curios", (String)"register_icon", () -> new Tuple((Object)identifier, (Object)icon));
        }
    }

    public static SoundEvent registerSound(String soundName) {
        ResourceLocation location = new ResourceLocation("enigmaticlegacy", soundName);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    public static AxisAlignedBB getBoundingBoxAroundEntity(Entity entity, double radius) {
        return new AxisAlignedBB(entity.func_226277_ct_() - radius, entity.func_226278_cu_() - radius, entity.func_226281_cx_() - radius, entity.func_226277_ct_() + radius, entity.func_226278_cu_() + radius, entity.func_226281_cx_() + radius);
    }

    public static void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector = finalVector.normalize();
        }
        entity.func_213293_j(finalVector.x * (double)modifier, finalVector.y * (double)modifier, finalVector.z * (double)modifier);
    }

    @Nullable
    public static LivingEntity getObservedEntity(PlayerEntity player, World world, float range, int maxDist) {
        LivingEntity newTarget = null;
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        List entities = new ArrayList();
        for (int distance = 1; entities.size() == 0 && distance < maxDist; ++distance) {
            target = target.add(new Vector3(player.func_70040_Z()).multiply(distance)).add(0.0, 0.5, 0.0);
            entities = player.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
            if (!entities.contains(player)) continue;
            entities.remove(player);
        }
        if (entities.size() > 0) {
            newTarget = (LivingEntity)entities.get(0);
        }
        return newTarget;
    }

    public static Vec3d getValidSpawn(World world, PlayerEntity player) {
        BlockPos pos = player.getBedLocation(world.func_201675_m().func_186058_p());
        if (pos != null && PlayerEntity.func_213822_a((IWorldReader)world, (BlockPos)pos, (boolean)false).isPresent()) {
            Vec3d vec = (Vec3d)PlayerEntity.func_213822_a((IWorldReader)world, (BlockPos)pos, (boolean)true).get();
            return vec;
        }
        pos = world.func_175694_M();
        if (world instanceof ServerWorld && ((ServerWorld)player.field_70170_p).func_180504_m() != null) {
            pos = ((ServerWorld)player.field_70170_p).func_180504_m();
            pos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() + 1);
        }
        return new Vec3d((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() - 0.5);
    }

    public static int getSpellstoneCooldown(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            if (spellstoneCooldowns.containsKey(player)) {
                return spellstoneCooldowns.get(player);
            }
            spellstoneCooldowns.put(player, 0);
            return 0;
        }
        return 0;
    }

    public static void setSpellstoneCooldown(PlayerEntity player, int cooldown) {
        if (!player.field_70170_p.field_72995_K) {
            spellstoneCooldowns.put(player, cooldown);
        }
    }

    public static boolean hasSpellstoneCooldown(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            return SuperpositionHandler.getSpellstoneCooldown(player) > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lookAt(double px, double py, double pz, ClientPlayerEntity me) {
        double dirx = me.func_226277_ct_() - px;
        double diry = me.func_226278_cu_() - py;
        double dirz = me.func_226281_cx_() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.field_70125_A = (float)pitch;
        me.field_70177_z = (float)(yaw += 90.0);
    }

    public static boolean validTeleport(Entity entity, double x_init, double y_init, double z_init, World world, int checkAxis) {
        int x = (int)x_init;
        int y = (int)y_init;
        int z = (int)z_init;
        BlockState block = world.func_180495_p(new BlockPos(x, y - 1, z));
        if (world.func_175623_d(new BlockPos(x, y - 1, z)) & block.func_200132_m()) {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (!(!world.func_175623_d(new BlockPos(x, y + counter - 1, z)) & world.func_180495_p(new BlockPos(x, y + counter - 1, z)).func_200132_m() & world.func_175623_d(new BlockPos(x, y + counter, z)) & world.func_175623_d(new BlockPos(x, y + counter + 1, z)))) continue;
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_71093_bK)), (Object)new PacketPortalParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 72, 1.0, false));
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.func_70634_a((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).func_70634_a((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                }
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_71093_bK)), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                return true;
            }
        } else {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (!(!world.func_175623_d(new BlockPos(x, y - counter - 1, z)) & world.func_180495_p(new BlockPos(x, y - counter - 1, z)).func_200132_m() & world.func_175623_d(new BlockPos(x, y - counter, z)) & world.func_175623_d(new BlockPos(x, y - counter + 1, z)))) continue;
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_71093_bK)), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.func_70634_a((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).func_70634_a((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                }
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_71093_bK)), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                return true;
            }
        }
        return false;
    }

    public static boolean validTeleportRandomly(Entity entity, World world, int radius) {
        int d = radius * 2;
        double x = entity.func_226277_ct_() + (Math.random() - 0.5) * (double)d;
        double y = entity.func_226278_cu_() + (Math.random() - 0.5) * (double)d;
        double z = entity.func_226281_cx_() + (Math.random() - 0.5) * (double)d;
        return SuperpositionHandler.validTeleport(entity, x, y, z, world, radius);
    }

    public static LootPool constructLootPool(String poolName, float minRolls, float maxRolls, LootEntry.Builder<?> ... entries) {
        LootPool.Builder poolBuilder = LootPool.func_216096_a();
        poolBuilder.name(poolName);
        poolBuilder.func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)minRolls, (float)maxRolls));
        for (LootEntry.Builder<?> entry : entries) {
            if (entry == null) continue;
            poolBuilder.func_216045_a(entry);
        }
        LootPool constructedPool = poolBuilder.func_216044_b();
        return constructedPool;
    }

    @Nullable
    public static StandaloneLootEntry.Builder<?> createOptionalLootEntry(Item item, int weight, float minCount, float maxCount) {
        IPerhaps perhaps;
        if (item instanceof IPerhaps && !(perhaps = (IPerhaps)item).isForMortals()) {
            return null;
        }
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minCount, (float)maxCount)));
    }

    @Nullable
    public static StandaloneLootEntry.Builder<?> createOptionalLootEntry(Item item, int weight) {
        IPerhaps perhaps;
        if (item instanceof IPerhaps && !(perhaps = (IPerhaps)item).isForMortals()) {
            return null;
        }
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight);
    }

    public static StandaloneLootEntry.Builder<?> itemEntryBuilderED(Item item, int weight, float enchantLevelMin, float enchantLevelMax, float damageMin, float damageMax) {
        StandaloneLootEntry.Builder builder = ItemLootEntry.func_216168_a((IItemProvider)item);
        builder.func_216086_a(weight);
        builder.func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)damageMax, (float)damageMin)));
        builder.func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)enchantLevelMin, (float)enchantLevelMax)).func_216059_e());
        return builder;
    }

    public static List<ResourceLocation> getEarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186422_d);
        lootChestList.add(LootTables.field_186424_f);
        lootChestList.add(LootTables.field_215816_g);
        return lootChestList;
    }

    public static List<ResourceLocation> getWaterDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_204115_q);
        lootChestList.add(LootTables.field_204114_p);
        lootChestList.add(LootTables.field_204773_u);
        lootChestList.add(LootTables.field_204312_r);
        return lootChestList;
    }

    public static List<ResourceLocation> getFieryDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186425_g);
        return lootChestList;
    }

    public static List<ResourceLocation> getAirDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_215824_o);
        return lootChestList;
    }

    public static List<ResourceLocation> getEnderDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186421_c);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedAir$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186429_k);
        lootChestList.add(LootTables.field_186430_l);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedEnder$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186428_j);
        lootChestList.add(LootTables.field_186427_i);
        return lootChestList;
    }

    public static List<ResourceLocation> getOverworldDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186422_d);
        lootChestList.add(LootTables.field_186424_f);
        lootChestList.add(LootTables.field_186427_i);
        lootChestList.add(LootTables.field_186428_j);
        lootChestList.add(LootTables.field_186429_k);
        lootChestList.add(LootTables.field_186430_l);
        lootChestList.add(LootTables.field_186431_m);
        lootChestList.add(LootTables.field_191192_o);
        lootChestList.add(LootTables.field_204114_p);
        lootChestList.add(LootTables.field_204115_q);
        lootChestList.add(LootTables.field_204772_t);
        lootChestList.add(LootTables.field_215813_K);
        return lootChestList;
    }

    public static List<ResourceLocation> getVillageChests() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_215814_e);
        lootChestList.add(LootTables.field_215815_f);
        lootChestList.add(LootTables.field_215816_g);
        lootChestList.add(LootTables.field_215817_h);
        lootChestList.add(LootTables.field_215818_i);
        lootChestList.add(LootTables.field_215819_j);
        lootChestList.add(LootTables.field_215820_k);
        lootChestList.add(LootTables.field_215821_l);
        lootChestList.add(LootTables.field_215822_m);
        lootChestList.add(LootTables.field_215823_n);
        lootChestList.add(LootTables.field_215824_o);
        lootChestList.add(LootTables.field_215825_p);
        lootChestList.add(LootTables.field_215826_q);
        lootChestList.add(LootTables.field_215827_r);
        lootChestList.add(LootTables.field_215828_s);
        lootChestList.add(LootTables.field_215829_t);
        return lootChestList;
    }

    public static void setPersistentBoolean(PlayerEntity player, String tag, boolean value) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        persistent.func_74757_a(tag, value);
    }

    public static boolean getPersistentBoolean(PlayerEntity player, String tag, boolean expectedValue) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (persistent.func_74764_b(tag)) {
            return persistent.func_74767_n(tag);
        }
        persistent.func_74757_a(tag, expectedValue);
        return expectedValue;
    }

    public static boolean hasPersistentTag(PlayerEntity player, String tag) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        return persistent.func_74764_b(tag);
    }

    public static boolean hasStoredAnvilField(PlayerEntity entity) {
        return EnigmaticEventHandler.anvilFields.containsKey(entity) && EnigmaticEventHandler.anvilFields.get(entity) != null && !EnigmaticEventHandler.anvilFields.get(entity).equals("");
    }

    public static boolean hasAdvancement(@Nonnull ServerPlayerEntity player, @Nonnull ResourceLocation location) {
        try {
            if (player.func_192039_O().func_192747_a(player.field_71133_b.func_191949_aK().func_192778_a(location)).func_192105_a()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static String generateRandomWorldNumber() {
        String number = "";
        while (number.length() < 4) {
            number = number.concat("" + random.nextInt(10));
        }
        number = number.concat("-");
        while (number.length() < 7) {
            number = number.concat("" + symbols[random.nextInt(symbols.length)]);
        }
        while (number.length() < 9) {
            number = number.concat("" + random.nextInt(10));
        }
        return number;
    }

    public static PlayerEntity getPlayerByName(World world, String name) {
        PlayerEntity player = null;
        for (PlayerEntity checkedPlayer : world.func_217369_A()) {
            if (!checkedPlayer.func_145748_c_().getString().equals(name)) continue;
            player = checkedPlayer;
        }
        return player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(List<EffectInstance> list, ItemStack itemIn, List<ITextComponent> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent itextcomponent = new TranslationTextComponent(effectinstance.func_76453_d(), new Object[0]);
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    itextcomponent.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c(), new Object[0]));
                }
                if (effectinstance.func_76459_b() > 20) {
                    itextcomponent.func_150258_a(" (").func_150258_a(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)).func_150258_a(")");
                }
                lores.add(itextcomponent.func_211708_a(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((ITextComponent)new StringTextComponent(""));
            lores.add(new TranslationTextComponent("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.RED));
            }
        }
    }

    public static boolean canPickStack(PlayerEntity player, ItemStack stack) {
        if (player.field_71071_by.func_70447_i() >= 0) {
            return true;
        }
        ArrayList allInventories = new ArrayList();
        allInventories.addAll(player.field_71071_by.field_70462_a);
        allInventories.addAll(player.field_71071_by.field_184439_c);
        for (ItemStack invStack : allInventories) {
            if (!SuperpositionHandler.canMergeStacks(invStack, stack, player.field_71071_by.func_70297_j_())) continue;
            return true;
        }
        return false;
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2, int invStackLimit) {
        return !stack1.func_190926_b() && SuperpositionHandler.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < invStackLimit;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getParticleMultiplier() {
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            return 0.35f;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
            return 0.65f;
        }
        return 1.0f;
    }
}

