/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.helpers;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ItemLoreHelper {
    public static void addLocalizedString(List<ITextComponent> list, String str) {
        list.add((ITextComponent)new TranslationTextComponent(str, new Object[0]));
    }

    public static void addLocalizedString(List<ITextComponent> list, String str, Object ... values) {
        list.add((ITextComponent)new TranslationTextComponent(str, values));
    }

    public static ItemStack mergeDisplayData(ItemStack from, ItemStack to) {
        CompoundNBT nbt = from.func_190925_c("display");
        ListNBT loreList = nbt.func_150295_c("Lore", 8).size() > 0 ? nbt.func_150295_c("Lore", 8) : to.func_190925_c("display").func_150295_c("Lore", 8);
        StringNBT displayName = nbt.func_74779_i("Name").length() > 0 ? StringNBT.func_229705_a_((String)nbt.func_74779_i("Name")) : StringNBT.func_229705_a_((String)to.func_190925_c("display").func_74779_i("Name"));
        CompoundNBT mergedData = new CompoundNBT();
        mergedData.func_218657_a("Lore", (INBT)loreList.func_74737_b());
        mergedData.func_218657_a("Name", (INBT)displayName.func_74737_b());
        to.func_196082_o().func_218657_a("display", (INBT)mergedData);
        return to;
    }

    public static ItemStack addLoreString(ItemStack stack, String string) {
        CompoundNBT nbt = stack.func_190925_c("display");
        ListNBT loreList = nbt.func_150295_c("Lore", 8);
        loreList.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(string))));
        nbt.func_218657_a("Lore", (INBT)loreList);
        return stack;
    }

    public static ItemStack setLoreString(ItemStack stack, String string, int index) {
        CompoundNBT nbt = stack.func_190925_c("display");
        ListNBT loreList = nbt.func_150295_c("Lore", 8);
        if (loreList.size() - 1 >= index) {
            loreList.set(index, (INBT)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(string))));
        } else {
            loreList.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(string))));
        }
        nbt.func_218657_a("Lore", (INBT)loreList);
        return stack;
    }

    public static ItemStack removeLoreString(ItemStack stack, int index) {
        CompoundNBT nbt = stack.func_190925_c("display");
        ListNBT loreList = nbt.func_150295_c("Lore", 8);
        if (index == -1 && loreList.size() > 0) {
            loreList.remove(loreList.size() - 1);
        } else if (loreList.size() - 1 >= index) {
            loreList.remove(index);
        }
        nbt.func_218657_a("Lore", (INBT)loreList);
        return stack;
    }

    public static ItemStack setLastLoreString(ItemStack stack, String string) {
        CompoundNBT nbt = stack.func_190925_c("display");
        ListNBT loreList = nbt.func_150295_c("Lore", 8);
        if (loreList.size() > 0) {
            loreList.set(loreList.size() - 1, (INBT)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(string))));
        } else {
            loreList.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(string))));
        }
        nbt.func_218657_a("Lore", (INBT)loreList);
        return stack;
    }

    public static ItemStack setDisplayName(ItemStack stack, String name) {
        CompoundNBT nbt = stack.func_190925_c("display");
        nbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(name)));
        return stack;
    }

    public static class AnvilParser {
        private boolean isLore;
        private int loreIndex = -1;
        private boolean removeString;
        private String handledString;

        private AnvilParser(String string) {
            this.handledString = string.toString();
            this.isLore = this.handledString.startsWith("!");
            this.removeString = this.handledString.startsWith("-!");
            if (this.isLore) {
                this.handledString = this.handledString.replaceFirst("!", "");
                String index = AnvilParser.parseIndex(this.handledString);
                this.loreIndex = Integer.parseInt(index);
                if (this.loreIndex != -1) {
                    this.handledString = this.handledString.replaceFirst(index, "");
                }
            } else if (this.removeString) {
                this.handledString = this.handledString.replaceFirst("-!", "");
                String index = AnvilParser.parseIndex(this.handledString);
                this.loreIndex = Integer.parseInt(index);
                if (this.loreIndex != -1) {
                    this.handledString = this.handledString.replaceFirst(index, "");
                }
            }
            this.handledString = AnvilParser.parseFormatting(this.handledString);
        }

        public static AnvilParser parseField(String field) {
            return new AnvilParser(field);
        }

        public static String parseFormatting(String field) {
            String formatter = new TranslationTextComponent("tooltip.enigmaticlegacy.paragraph", new Object[0]).func_150254_d();
            String subformat = new TranslationTextComponent("tooltip.enigmaticlegacy.subformat", new Object[0]).func_150254_d();
            return field.replace(subformat, formatter);
        }

        public static String parseIndex(String field) {
            String number = "";
            int index = -1;
            for (char symbol : field.toCharArray()) {
                if (!Character.isDigit(symbol) || (number = number + symbol).length() >= 2) break;
            }
            if (!number.equals("")) {
                return number;
            }
            return "" + index;
        }

        public boolean isLoreString() {
            return this.isLore;
        }

        public boolean shouldRemoveString() {
            return this.removeString;
        }

        public int getLoreIndex() {
            return this.loreIndex;
        }

        public String getFormattedString() {
            return this.handledString;
        }
    }
}

