/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.helpers;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.brewing.ComplexBrewingRecipe;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.objects.AdvancedPotion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class PotionHelper {
    public static int getColor(ItemStack stack) {
        if (PotionHelper.isAdvancedPotion(stack) && PotionHelper.getEffects(stack) != null && PotionHelper.getEffects(stack).size() > 0) {
            return PotionUtils.func_185181_a(PotionHelper.getEffects(stack));
        }
        return PotionUtils.func_190932_c((ItemStack)stack);
    }

    public static boolean isAdvancedPotion(ItemStack stack) {
        return ItemNBTHelper.verifyExistance(stack, "EnigmaticPotion");
    }

    public static List<EffectInstance> getEffects(ItemStack stack) {
        AdvancedPotion potion;
        if (PotionHelper.isAdvancedPotion(stack) && (potion = PotionHelper.getAdvancedPotion(ItemNBTHelper.getString(stack, "EnigmaticPotion", "nothing"))) != null) {
            return potion.getEffects();
        }
        return new ArrayList<EffectInstance>();
    }

    public static AdvancedPotion getAdvancedPotion(ItemStack stack) {
        if (PotionHelper.isAdvancedPotion(stack)) {
            return PotionHelper.getAdvancedPotion(ItemNBTHelper.getString(stack, "EnigmaticPotion", "nothing"));
        }
        return EnigmaticLegacy.EMPTY;
    }

    public static ItemStack setAdvancedPotion(ItemStack stack, AdvancedPotion potion) {
        ItemNBTHelper.setString(stack, "EnigmaticPotion", potion.getId());
        return stack;
    }

    public static ItemStack setAdvancedPotion(ItemStack stack, String id) {
        ItemNBTHelper.setString(stack, "EnigmaticPotion", id);
        return stack;
    }

    public static AdvancedPotion getAdvancedPotion(String identifier) {
        for (AdvancedPotion potion : EnigmaticLegacy.ultimatePotionTypes) {
            if (!potion.getId().equals(identifier)) continue;
            return potion;
        }
        for (AdvancedPotion potion : EnigmaticLegacy.commonPotionTypes) {
            if (!potion.getId().equals(identifier)) continue;
            return potion;
        }
        return EnigmaticLegacy.EMPTY;
    }

    public static HashMap<Ingredient, Ingredient> constructIngredientMap(Ingredient ... ingredients) {
        HashMap<Ingredient, Ingredient> returnMap = new HashMap<Ingredient, Ingredient>();
        if (ingredients.length % 2 != 0) {
            throw new IllegalArgumentException("Uneven number of ingredients passed. This must not be!");
        }
        for (int counter = 0; counter < ingredients.length; counter += 2) {
            returnMap.put(ingredients[counter], ingredients[counter + 1]);
        }
        return returnMap;
    }

    public static ItemStack createAdvancedPotion(Item item, AdvancedPotion potion) {
        return PotionHelper.setAdvancedPotion(new ItemStack((IItemProvider)item), potion);
    }

    public static ItemStack createVanillaPotion(Item item, Potion potion) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)item), (Potion)potion);
    }

    public static void registerCommonPotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185233_e)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151128_bU})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.LONG_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.STRONG_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185233_e)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151128_bU}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.LONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.LONG_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.STRONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.STRONG_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185233_e)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151128_bU}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.LONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.LONG_HASTE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.STRONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.STRONG_HASTE)));
    }

    public static void registerBasicUltimatePotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185235_g)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_NIGHT_VISION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185237_i)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_INVISIBILITY)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185242_n)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_FIRE_RESISTANCE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185251_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HEALING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185253_y)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HARMING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_204842_P)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SLOW_FALLING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185227_J)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185249_u)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_WATER_BREATHING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185224_G)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185225_H)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185239_k)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185240_l)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185244_p)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185245_q)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185247_s)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_203185_t)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_203187_v)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_203188_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185218_A)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185219_B)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185221_D)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_151068_bn, Potions.field_185222_E)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.LONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.STRONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HASTE)));
    }

    public static void registerSplashUltimatePotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185235_g)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_NIGHT_VISION)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_NIGHT_VISION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185237_i)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_INVISIBILITY)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_INVISIBILITY)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185242_n)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_FIRE_RESISTANCE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_FIRE_RESISTANCE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185251_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HEALING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HEALING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185253_y)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HARMING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HARMING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_204842_P)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SLOW_FALLING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SLOW_FALLING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185227_J)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_WEAKNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185249_u)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_WATER_BREATHING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_WATER_BREATHING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185224_G)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185225_H)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_STRENGTH)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185239_k)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185240_l)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_LEAPING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185244_p)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185245_q)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SWIFTNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185247_s)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_203185_t)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_SLOWNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_203187_v)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_203188_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_TURTLE_MASTER)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185218_A)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185219_B)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_POISON)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185221_D)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185155_bH, Potions.field_185222_E)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_REGENERATION)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.LONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionSplash, EnigmaticLegacy.STRONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionBase, EnigmaticLegacy.ULTIMATE_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HASTE)));
    }

    public static void registerLingeringUltimatePotions() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185235_g)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_NIGHT_VISION)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_NIGHT_VISION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185237_i)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_INVISIBILITY)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_INVISIBILITY)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185242_n)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_FIRE_RESISTANCE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_FIRE_RESISTANCE)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185251_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HEALING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_HEALING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185253_y)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HARMING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_HARMING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_204842_P)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SLOW_FALLING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_SLOW_FALLING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185227_J)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_WEAKNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_WEAKNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185249_u)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_WATER_BREATHING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_WATER_BREATHING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185224_G)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185225_H)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_STRENGTH)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_STRENGTH)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185239_k)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185240_l)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_LEAPING)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_LEAPING)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185244_p)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185245_q)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SWIFTNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_SWIFTNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185247_s)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_203185_t)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_SLOWNESS)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_SLOWNESS)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_203187_v)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_203188_w)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_TURTLE_MASTER)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_TURTLE_MASTER)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185218_A)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185219_B)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_POISON)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_POISON)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185221_D)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createVanillaPotion(Items.field_185156_bI, Potions.field_185222_E)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_REGENERATION)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_REGENERATION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ComplexBrewingRecipe(PotionHelper.constructIngredientMap(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.LONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionLingering, EnigmaticLegacy.STRONG_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{EnigmaticLegacy.astralDust}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionSplash, EnigmaticLegacy.ULTIMATE_HASTE)}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185157_bK})), PotionHelper.createAdvancedPotion(EnigmaticLegacy.ultimatePotionLingering, EnigmaticLegacy.ULTIMATE_HASTE)));
    }
}

