/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class AngelBlessing
extends ItemAdvancedCurio
implements ISpellstone {
    protected double range = 4.0;

    public AngelBlessing() {
        super(ItemAdvancedCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "angel_blessing"));
        this.immunityList.add(DamageSource.field_76379_h.field_76373_n);
        this.immunityList.add(DamageSource.field_188406_j.field_76373_n);
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ANGEL_BLESSING_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessingCooldown", Float.valueOf((float)ConfigHandler.ANGEL_BLESSING_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing6");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void triggerActiveAbility(World world, PlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown(player)) {
            return;
        }
        Vector3 accelerationVec = new Vector3(player.func_70040_Z());
        Vector3 motionVec = new Vector3(player.func_213322_ci());
        if (player.func_184613_cA()) {
            accelerationVec = accelerationVec.multiply(ConfigHandler.ANGEL_BLESSING_ACCELERATION_MODIFIER_ELYTRA.getValue());
            accelerationVec = accelerationVec.multiply(1.0 / (motionVec.mag() * 2.25));
        } else {
            accelerationVec = accelerationVec.multiply(ConfigHandler.ANGEL_BLESSING_ACCELERATION_MODIFIER.getValue());
        }
        Vector3 finalMotion = new Vector3(motionVec.x + accelerationVec.x, motionVec.y + accelerationVec.y, motionVec.z + accelerationVec.z);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketPlayerMotion(finalMotion.x, finalMotion.y, finalMotion.z));
        player.func_213293_j(finalMotion.x, finalMotion.y, finalMotion.z);
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187528_aR, SoundCategory.PLAYERS, 1.0f, (float)((double)0.6f + Math.random() * 0.1));
        SuperpositionHandler.setSpellstoneCooldown(player, ConfigHandler.ANGEL_BLESSING_COOLDOWN.getValue());
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        List projectileEntities = living.field_70170_p.func_217357_a(DamagingProjectileEntity.class, new AxisAlignedBB(living.func_226277_ct_() - this.range, living.func_226278_cu_() - this.range, living.func_226281_cx_() - this.range, living.func_226277_ct_() + this.range, living.func_226278_cu_() + this.range, living.func_226281_cx_() + this.range));
        List arrowEntities = living.field_70170_p.func_217357_a(AbstractArrowEntity.class, new AxisAlignedBB(living.func_226277_ct_() - this.range, living.func_226278_cu_() - this.range, living.func_226281_cx_() - this.range, living.func_226277_ct_() + this.range, living.func_226278_cu_() + this.range, living.func_226281_cx_() + this.range));
        List potionEntities = living.field_70170_p.func_217357_a(PotionEntity.class, new AxisAlignedBB(living.func_226277_ct_() - this.range, living.func_226278_cu_() - this.range, living.func_226281_cx_() - this.range, living.func_226277_ct_() + this.range, living.func_226278_cu_() + this.range, living.func_226281_cx_() + this.range));
        for (DamagingProjectileEntity entity : projectileEntities) {
            this.redirect(living, (Entity)entity);
        }
        for (DamagingProjectileEntity entity : arrowEntities) {
            this.redirect(living, (Entity)entity);
        }
        for (DamagingProjectileEntity entity : potionEntities) {
            this.redirect(living, (Entity)entity);
        }
    }

    public void redirect(LivingEntity bearer, Entity redirected) {
        if (redirected instanceof UltimateWitherSkullEntity || redirected instanceof WitherSkullEntity) {
            return;
        }
        Vector3 entityPos = Vector3.fromEntityCenter(redirected);
        Vector3 bearerPos = Vector3.fromEntityCenter((Entity)bearer);
        Vector3 redirection = entityPos.subtract(bearerPos);
        redirection = redirection.normalize();
        if (redirected instanceof AbstractArrowEntity && ((AbstractArrowEntity)redirected).func_212360_k() == bearer) {
            if (redirected instanceof TridentEntity) {
                TridentEntity trident = (TridentEntity)redirected;
                if (trident.field_203052_f > 0) {
                    return;
                }
            }
            redirected.func_213293_j(redirected.func_213322_ci().field_72450_a * 1.75, redirected.func_213322_ci().field_72448_b * 1.75, redirected.func_213322_ci().field_72449_c * 1.75);
        } else {
            redirected.func_213293_j(redirection.x, redirection.y, redirection.z);
        }
        if (redirected instanceof DamagingProjectileEntity) {
            DamagingProjectileEntity redirectedProjectile = (DamagingProjectileEntity)redirected;
            redirectedProjectile.field_70232_b = redirection.x / 4.0;
            redirectedProjectile.field_70233_c = redirection.y / 4.0;
            redirectedProjectile.field_70230_d = redirection.z / 4.0;
        }
    }
}

