/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EnigmaticItem
extends ItemAdvancedCurio
implements ISpellstone {
    public HashMap<PlayerEntity, Boolean> flightMap = new HashMap();

    public EnigmaticItem() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "enigmatic_item"));
        this.immunityList.add(DamageSource.field_76379_h.field_76373_n);
        this.immunityList.add(DamageSource.field_188406_j.field_76373_n);
        this.immunityList.add(DamageSource.field_76367_g.field_76373_n);
        this.immunityList.add(DamageSource.field_191291_g.field_76373_n);
        this.immunityList.add(DamageSource.field_76369_e.field_76373_n);
        this.immunityList.add(DamageSource.field_190095_e.field_76373_n);
        this.immunityList.add(DamageSource.field_76371_c.field_76373_n);
        this.immunityList.add(DamageSource.field_76372_a.field_76373_n);
        this.immunityList.add(DamageSource.field_76370_b.field_76373_n);
        this.immunityList.add(DamageSource.field_76368_d.field_76373_n);
        this.immunityList.add(DamageSource.field_76380_i.field_76373_n);
        this.immunityList.add(DamageSource.field_76366_f.field_76373_n);
        this.immunityList.add(DamageSource.field_220302_v.field_76373_n);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItemCooldown", Float.valueOf((float)ConfigHandler.ENIGMATIC_ITEM_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticItem11");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity entityLivingBase) {
        if (entityLivingBase.func_70027_ad()) {
            entityLivingBase.func_70066_B();
        }
        entityLivingBase.func_195061_cb();
    }

    public void handleEnigmaticFlight(PlayerEntity player) {
        try {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.enigmaticItem)) {
                this.flightMap.put(player, true);
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                }
            } else if (this.flightMap.get(player).booleanValue()) {
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                }
                this.flightMap.put(player, false);
            }
        }
        catch (NullPointerException ex) {
            this.flightMap.put(player, false);
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (world.field_72995_K || SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
        this.launchWitherSkull(world, (PlayerEntity)player, Item.field_77697_d.nextDouble() <= 0.25);
        SuperpositionHandler.setSpellstoneCooldown((PlayerEntity)player, ConfigHandler.ENIGMATIC_ITEM_COOLDOWN.getValue());
    }

    private void launchWitherSkull(World world, PlayerEntity player, boolean invulnerable) {
        UltimateWitherSkullEntity witherskullentity;
        world.func_217378_a((PlayerEntity)null, 1024, new BlockPos((Entity)player), 0);
        Vector3 look = new Vector3(player.func_70040_Z()).multiply(1.0, 0.0, 1.0);
        double playerRot = Math.toRadians(player.field_70177_z + 90.0f);
        if (look.x == 0.0 && look.z == 0.0) {
            look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
        }
        look = look.normalize().multiply(-2.0);
        double div = -0.75 + Item.field_77697_d.nextDouble() * 0.75;
        double mod = -0.5 + Item.field_77697_d.nextDouble() * 6.0;
        Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)player)).add(0.0, 1.6, div * 0.1);
        Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
        double rot = mod * Math.PI / 4.0 - 1.5707963267948966;
        Vector3 axis1 = axis.multiply(div * 3.5 + 5.0).rotate(rot, look);
        if (axis1.y < 0.0) {
            axis1 = axis1.multiply(1.0, -1.0, 1.0);
        }
        Vector3 end = pl.add(axis1);
        LivingEntity doomedOne = SuperpositionHandler.getObservedEntity(player, world, 3.0f, 64);
        UltimateWitherSkullEntity ultimateWitherSkullEntity = witherskullentity = doomedOne != null ? new UltimateWitherSkullEntity(world, (LivingEntity)player, doomedOne) : new UltimateWitherSkullEntity(world, (LivingEntity)player);
        if (invulnerable) {
            witherskullentity.setSkullInvulnerable(true);
        }
        witherskullentity.func_70107_b(end.x, end.y, end.z);
        world.func_217376_c((Entity)witherskullentity);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(witherskullentity.func_226277_ct_(), witherskullentity.func_226278_cu_(), witherskullentity.func_226281_cx_(), 64.0, witherskullentity.field_71093_bK)), (Object)new PacketWitherParticles(witherskullentity.func_226277_ct_(), witherskullentity.func_226278_cu_() + (double)(witherskullentity.func_213302_cg() / 2.0f), witherskullentity.func_226281_cx_(), 8, false));
    }
}

