/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseArmor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumArmor
extends ItemBaseArmor {
    public EtheriumArmor(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, ItemBaseArmor.getDefaultProperties().func_208103_a(Rarity.RARE));
    }

    public boolean hasShield(@Nonnull PlayerEntity player) {
        return player != null && this.hasFullSet(player) && (double)(player.func_110143_aJ() / player.func_110138_aP()) <= ConfigHandler.ETHERIUM_ARMOR_SHIELD_THRESHOLD.getValue().asMultiplier(false);
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_ARMOR_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.hasShiftDown()) {
            if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumHelmet)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumHelmet1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumChestplate)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumChestplate1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumLeggings)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumLeggings1");
            } else if (stack.func_77973_b().equals(EnigmaticLegacy.etheriumBoots)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumBoots1");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (this.hasFullSet((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus2", ConfigHandler.ETHERIUM_ARMOR_SHIELD_THRESHOLD.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus4", ConfigHandler.ETHERIUM_ARMOR_SHIELD_REDUCTION.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus6");
        }
        if (stack.func_77948_v()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        }
    }
}

