/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumAxe
extends AxeItem
implements IPerhaps {
    public Set<Material> effectiveMaterials;

    public EtheriumAxe() {
        super((IItemTier)EnigmaticMaterials.ETHERIUM, 10.0f, -3.2f, ItemBaseTool.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_axe"));
        this.effectiveMaterials = Sets.newHashSet();
        this.effectiveMaterials.add(Material.field_151575_d);
        this.effectiveMaterials.add(Material.field_151584_j);
        this.effectiveMaterials.add(Material.field_151570_A);
        this.effectiveMaterials.add(Material.field_215713_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ConfigHandler.ETHERIUM_AXE_VOLUME.getValue() == -1) {
            return;
        }
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumAxe1", ConfigHandler.ETHERIUM_AXE_VOLUME.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumAxe2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_TOOLS_ENABLED.getValue();
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_225608_bj_() && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && ConfigHandler.ETHERIUM_AXE_VOLUME.getValue() != -1) {
            Direction face = Direction.UP;
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos.func_177982_a(0, (ConfigHandler.ETHERIUM_AXE_VOLUME.getValue() - 1) / 2, 0), this.effectiveMaterials, ConfigHandler.ETHERIUM_AXE_VOLUME.getValue(), ConfigHandler.ETHERIUM_AXE_VOLUME.getValue(), false, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

