/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class EtheriumPickaxe
extends ItemBaseTool {
    public EtheriumPickaxe() {
        super(1.0f, -2.8f, EnigmaticMaterials.ETHERIUM, new HashSet<Block>(), ItemBaseTool.getDefaultProperties().func_200915_b((int)((double)EnigmaticMaterials.ETHERIUM.func_200926_a() * 1.5)).addToolType(ToolType.PICKAXE, EnigmaticMaterials.ETHERIUM.func_200925_d()).func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_pickaxe"));
        this.effectiveMaterials.add(Material.field_151573_f);
        this.effectiveMaterials.add(Material.field_151576_e);
        this.effectiveMaterials.add(Material.field_151574_g);
        this.effectiveMaterials.add(Material.field_151592_s);
        this.effectiveMaterials.add(Material.field_151598_x);
        this.effectiveMaterials.add(Material.field_151588_w);
        this.effectiveMaterials.add(Material.field_215711_w);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ConfigHandler.ETHERIUM_PICKAXE_RADIUS.getValue() == -1) {
            return;
        }
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumPickaxe1", ConfigHandler.ETHERIUM_PICKAXE_RADIUS.getValue(), ConfigHandler.ETHERIUM_PICKAXE_DEPTH.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumPickaxe2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_TOOLS_ENABLED.getValue();
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        RayTraceResult trace;
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_225608_bj_() && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && ConfigHandler.ETHERIUM_PICKAXE_RADIUS.getValue() != -1 && (trace = AOEMiningHelper.calcRayTrace(world, (PlayerEntity)entityLiving, RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos, this.effectiveMaterials, ConfigHandler.ETHERIUM_PICKAXE_RADIUS.getValue(), ConfigHandler.ETHERIUM_PICKAXE_DEPTH.getValue(), true, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }
}

