/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumScythe
extends SwordItem
implements IPerhaps {
    protected static final Map<Block, BlockState> HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    public Set<Material> effectiveMaterials;

    public EtheriumScythe() {
        super((IItemTier)EnigmaticMaterials.ETHERIUM, 3, -2.0f, ItemBaseTool.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_scythe"));
        this.effectiveMaterials = Sets.newHashSet();
        this.effectiveMaterials.add(Material.field_151584_j);
        this.effectiveMaterials.add(Material.field_215713_z);
        this.effectiveMaterials.add(Material.field_215712_y);
        this.effectiveMaterials.add(Material.field_204868_h);
        this.effectiveMaterials.add(Material.field_151585_k);
        this.effectiveMaterials.add(Material.field_203243_f);
        this.effectiveMaterials.add(Material.field_151582_l);
        this.effectiveMaterials.add(Material.field_151570_A);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue() == -1) {
            return;
        }
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe1", ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe2", ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_TOOLS_ENABLED.getValue();
    }

    public static boolean attemptTransformLand(World world, PlayerEntity player, BlockPos blockpos, ItemStack item, Hand hand) {
        BlockState blockstate;
        if (world.func_175623_d(blockpos.func_177984_a()) && (blockstate = HOE_LOOKUP.get(world.func_180495_p(blockpos).func_177230_c())) != null) {
            world.func_184133_a(player, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (player != null) {
                    item.func_222118_a(1, (LivingEntity)player, p_220043_1_ -> p_220043_1_.func_213334_d(hand));
                }
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType type = Items.field_151012_L.func_195939_a(context);
        if (context.func_195999_j().func_225608_bj_()) {
            return type;
        }
        int supRad = (ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue() - 1) / 2;
        if (type == ActionResultType.SUCCESS) {
            for (int x = -supRad; x <= supRad; ++x) {
                for (int z = -supRad; z <= supRad; ++z) {
                    if (x == 0 & z == 0) continue;
                    EtheriumScythe.attemptTransformLand(context.func_195991_k(), context.func_195999_j(), context.func_195995_a().func_177982_a(x, 0, z), context.func_195996_i(), context.func_221531_n());
                }
            }
        }
        return type;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_225608_bj_() && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue() != -1) {
            Direction face = Direction.UP;
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos.func_177982_a(0, (ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue() - 1) / 2, 0), this.effectiveMaterials, ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue(), ConfigHandler.ETHERIUM_SCYTHE_VOLUME.getValue(), false, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.func_200891_e().func_200928_b();
    }
}

