/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class EtheriumShovel
extends ToolItem
implements IPerhaps {
    public static Item.Properties integratedProperties = new Item.Properties();
    public Set<Material> effectiveMaterials;

    public EtheriumShovel() {
        super(2.5f, -3.0f, (IItemTier)EnigmaticMaterials.ETHERIUM, new HashSet(), ItemBaseTool.getDefaultProperties().func_200915_b((int)((double)EnigmaticMaterials.ETHERIUM.func_200926_a() * 1.5)).addToolType(ToolType.SHOVEL, EnigmaticMaterials.ETHERIUM.func_200925_d()).func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_shovel"));
        this.effectiveMaterials = Sets.newHashSet();
        this.effectiveMaterials.add(Material.field_151578_c);
        this.effectiveMaterials.add(Material.field_151577_b);
        this.effectiveMaterials.add(Material.field_151597_y);
        this.effectiveMaterials.add(Material.field_151596_z);
        this.effectiveMaterials.add(Material.field_151595_p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (ConfigHandler.ETHERIUM_SHOVEL_RADIUS.getValue() == -1) {
            return;
        }
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumShovel1", ConfigHandler.ETHERIUM_SHOVEL_RADIUS.getValue(), ConfigHandler.ETHERIUM_SHOVEL_DEPTH.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumShovel2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.ETHERIUM_TOOLS_ENABLED.getValue();
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        RayTraceResult trace;
        if (entityLiving instanceof PlayerEntity && !entityLiving.func_225608_bj_() && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && ConfigHandler.ETHERIUM_SHOVEL_RADIUS.getValue() != -1 && (trace = AOEMiningHelper.calcRayTrace(world, (PlayerEntity)entityLiving, RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos, this.effectiveMaterials, ConfigHandler.ETHERIUM_SHOVEL_RADIUS.getValue(), ConfigHandler.ETHERIUM_SHOVEL_DEPTH.getValue(), false, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return Items.field_151047_v.func_195939_a(context);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return Items.field_151047_v.func_150897_b(blockIn);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

