/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerSetlook;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EyeOfNebula
extends ItemAdvancedCurio
implements ISpellstone {
    public EyeOfNebula() {
        super(ItemAdvancedCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "eye_of_nebula"));
        this.resistanceList.put(DamageSource.field_76376_m.func_76355_l(), () -> Float.valueOf(ConfigHandler.EYE_OF_NEBULA_MAGIC_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put(DamageSource.field_188407_q.func_76355_l(), () -> Float.valueOf(ConfigHandler.EYE_OF_NEBULA_MAGIC_RESISTANCE.getValue().asModifierInverted()));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.EYE_OF_NEBULA_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebulaCooldown", Float.valueOf((float)ConfigHandler.EYE_OF_NEBULA_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula4", ConfigHandler.EYE_OF_NEBULA_MAGIC_RESISTANCE.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula5", ConfigHandler.EYE_OF_NEBULA_DODGE_PROBABILITY.getValue().asPercentage() + "%");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
        LivingEntity target = SuperpositionHandler.getObservedEntity((PlayerEntity)player, world, 3.0f, (int)ConfigHandler.EYE_OF_NEBULA_PHASE_RANGE.getValue());
        if (target != null) {
            Vector3 targetPos = Vector3.fromEntityCenter((Entity)target);
            Vector3 chaserPos = Vector3.fromEntityCenter((Entity)player);
            Vector3 dir = targetPos.subtract(chaserPos);
            dir = dir.normalize();
            dir = dir.multiply(1.5);
            dir = targetPos.add(dir);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_71093_bK)), (Object)new PacketPortalParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 72, 1.0, false));
            player.func_70634_a(dir.x, target.func_226278_cu_() + 0.25, dir.z);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPlayerSetlook(target.func_226277_ct_(), target.func_226278_cu_() - 1.0 + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_()));
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_71093_bK)), (Object)new PacketRecallParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 24, false));
            SuperpositionHandler.setSpellstoneCooldown((PlayerEntity)player, ConfigHandler.EYE_OF_NEBULA_COOLDOWN.getValue());
        }
    }
}

