/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForbiddenAxe
extends SwordItem
implements IPerhaps {
    public ForbiddenAxe() {
        super((IItemTier)EnigmaticMaterials.FORBIDDENAXE, 6, -2.4f, ItemBaseTool.getDefaultProperties().func_200915_b(2000).func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "forbidden_axe"));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.FORBIDDEN_AXE_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe2", ConfigHandler.FORBIDDEN_AXE_BEHEADING_BONUS.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack);
        try {
            if (SuperpositionHandler.hasCurio((LivingEntity)Minecraft.func_71410_x().field_71439_g, EnigmaticLegacy.monsterCharm) && ConfigHandler.MONSTER_CHARM_BONUS_LOOTING.getValue()) {
                ++looting;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxeBeheadingChance", ConfigHandler.FORBIDDEN_AXE_BEHEADING_BASE.getValue().asPercentage() + ConfigHandler.FORBIDDEN_AXE_BEHEADING_BONUS.getValue().asPercentage() * looting + "%");
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }
}

