/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GolemHeart
extends ItemAdvancedCurio
implements ISpellstone {
    public Multimap<String, AttributeModifier> attributesDefault = HashMultimap.create();
    public Multimap<String, AttributeModifier> attributesNoArmor = HashMultimap.create();

    public GolemHeart() {
        super(ItemAdvancedCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "golem_heart"));
        this.immunityList.add(DamageSource.field_76367_g.field_76373_n);
        this.immunityList.add(DamageSource.field_191291_g.field_76373_n);
        this.immunityList.add(DamageSource.field_76368_d.field_76373_n);
        this.immunityList.add(DamageSource.field_82729_p.field_76373_n);
        this.immunityList.add(DamageSource.field_220302_v.field_76373_n);
        this.resistanceList.put(DamageSource.field_76377_j.field_76373_n, () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put("mob", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put("explosion", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put("explosion.player", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put("player", () -> Float.valueOf(ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asModifierInverted()));
        this.resistanceList.put(DamageSource.field_76376_m.field_76373_n, () -> Float.valueOf((float)ConfigHandler.GOLEM_HEART_VULNERABILITY_MODIFIER.getValue()));
        this.resistanceList.put(DamageSource.field_188407_q.field_76373_n, () -> Float.valueOf((float)ConfigHandler.GOLEM_HEART_VULNERABILITY_MODIFIER.getValue()));
    }

    public void initAttributes() {
        this.attributesDefault.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("15faf191-bf21-4654-b359-cc1f4f1243bf"), "GolemHeart DAB", ConfigHandler.GOLEM_HEART_DEFAULT_ARMOR.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesDefault.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("10faf191-bf21-4554-b359-cc1f4f1233bf"), "GolemHeart KR", (double)ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("14faf191-bf23-4654-b359-cc1f4f1243bf"), "GolemHeart SAB", ConfigHandler.GOLEM_HEART_SUPER_ARMOR.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("11faf181-bf23-4354-b359-cc1f5f1253bf"), "GolemHeart STB", ConfigHandler.GOLEM_HEART_SUPER_ARMOR_TOUGHNESS.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("12faf181-bf21-4554-b359-cc1f4f1254bf"), "GolemHeart KR", (double)ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.GOLEM_HEART_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeartCooldown", Float.valueOf((float)ConfigHandler.GOLEM_HEART_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart4", (int)ConfigHandler.GOLEM_HEART_DEFAULT_ARMOR.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart6", (int)ConfigHandler.GOLEM_HEART_SUPER_ARMOR.getValue(), (int)ConfigHandler.GOLEM_HEART_SUPER_ARMOR_TOUGHNESS.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart7", ConfigHandler.GOLEM_HEART_KNOCKBACK_RESISTANCE.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart8", ConfigHandler.GOLEM_HEART_MELEE_RESISTANCE.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart9", ConfigHandler.GOLEM_HEART_EXPLOSION_RESISTANCE.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart11");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
    }

    @Override
    public void onUnequipped(String identifier, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AbstractAttributeMap map = player.func_110140_aT();
            map.func_111148_a(this.attributesDefault);
            map.func_111148_a(this.attributesNoArmor);
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AbstractAttributeMap map = player.func_110140_aT();
            int armorAmount = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack.func_190926_b()) continue;
                ++armorAmount;
            }
            if (armorAmount != 0) {
                map.func_111148_a(this.attributesDefault);
                map.func_111148_a(this.attributesNoArmor);
                map.func_111147_b(this.attributesDefault);
            } else {
                map.func_111148_a(this.attributesDefault);
                map.func_111148_a(this.attributesNoArmor);
                map.func_111147_b(this.attributesNoArmor);
            }
        }
    }
}

