/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeavenScroll
extends ItemBaseCurio {
    public HashMap<PlayerEntity, Boolean> flyMap = new HashMap();

    public HeavenScroll() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "heaven_scroll"));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.HEAVEN_SCROLL_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            if (Math.random() <= 0.025 * ConfigHandler.HEAVEN_SCROLL_XP_COST_MODIFIER.getValue() & player.field_71075_bZ.field_75100_b) {
                player.func_195068_e(-1);
            }
            try {
                if (player.field_71067_cb > 0) {
                    if (!player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                    }
                    player.func_71016_p();
                    this.flyMap.put(player, true);
                } else if (this.flyMap.get(player).booleanValue()) {
                    if (!player.func_184812_l_()) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.func_71016_p();
                    }
                    this.flyMap.put(player, false);
                }
            }
            catch (NullPointerException ex) {
                this.flyMap.put(player, false);
            }
        }
    }

    @Override
    public void onUnequipped(String identifier, LivingEntity entityLivingBase) {
        if (entityLivingBase instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLivingBase;
            if (!player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
            this.flyMap.put(player, false);
        }
    }
}

