/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagmaHeart
extends ItemAdvancedCurio
implements ISpellstone {
    public List<String> nemesisList = new ArrayList<String>();

    public MagmaHeart() {
        super(ItemAdvancedCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "magma_heart"));
        this.immunityList.add(DamageSource.field_76371_c.field_76373_n);
        this.immunityList.add(DamageSource.field_76372_a.field_76373_n);
        this.immunityList.add(DamageSource.field_76370_b.field_76373_n);
        this.immunityList.add(DamageSource.field_190095_e.field_76373_n);
        this.nemesisList.add("mob");
        this.nemesisList.add(DamageSource.field_76377_j.field_76373_n);
        this.nemesisList.add("player");
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MAGMA_HEART_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeartCooldown", Float.valueOf((float)ConfigHandler.BLAZING_CORE_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magmaHeart8");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (living.func_70027_ad()) {
            living.func_70066_B();
        }
    }
}

