/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagnetRing
extends ItemBaseCurio {
    public MagnetRing() {
        this(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "magnet_ring"));
    }

    public MagnetRing(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MAGNET_RING_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.magnetRing1", ConfigHandler.MAGNET_RING_RANGE.getValue());
            ItemLoreHelper.addLocalizedString(list, ConfigHandler.INVERT_MAGNETS_SHIFT.getValue() ? "tooltip.enigmaticlegacy.magnetRing2_alt" : "tooltip.enigmaticlegacy.magnetRing2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (ConfigHandler.INVERT_MAGNETS_SHIFT.getValue() ? !living.func_225608_bj_() : living.func_225608_bj_() || !(living instanceof PlayerEntity)) {
            return;
        }
        double x = living.func_226277_ct_();
        double y = living.func_226278_cu_() + 0.75;
        double z = living.func_226281_cx_();
        List items = living.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)ConfigHandler.MAGNET_RING_RANGE.getValue(), y - (double)ConfigHandler.MAGNET_RING_RANGE.getValue(), z - (double)ConfigHandler.MAGNET_RING_RANGE.getValue(), x + (double)ConfigHandler.MAGNET_RING_RANGE.getValue(), y + (double)ConfigHandler.MAGNET_RING_RANGE.getValue(), z + (double)ConfigHandler.MAGNET_RING_RANGE.getValue()));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (!this.canPullItem(item)) continue;
            if (pulled > 200) break;
            if (!SuperpositionHandler.canPickStack((PlayerEntity)living, item.func_92059_d())) continue;
            SuperpositionHandler.setEntityMotionFromVector((Entity)item, new Vector3(x, y, z), 0.45f);
            item.func_174868_q();
            for (int counter = 0; counter <= 2; ++counter) {
                living.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, item.func_226277_ct_(), item.func_226278_cu_() - item.func_70033_W() + (double)(item.func_213302_cg() / 2.0f), item.func_226281_cx_(), (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1);
            }
            ++pulled;
        }
    }

    protected boolean canPullItem(ItemEntity item) {
        ItemStack stack = item.func_92059_d();
        return item.func_70089_S() && !stack.func_190926_b() && !item.getPersistentData().func_74767_n("PreventRemoteMovement");
    }
}

