/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MiningCharm
extends ItemBaseCurio {
    public final int nightVisionDuration = 210;

    public MiningCharm() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "mining_charm"));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.MINING_CHARM_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        TranslationTextComponent mode = new TranslationTextComponent("tooltip.enigmaticlegacy.enabled", new Object[0]);
        if (ItemNBTHelper.verifyExistance(stack, "nightVisionEnabled") && !ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            mode = new TranslationTextComponent("tooltip.enigmaticlegacy.disabled", new Object[0]);
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm1", ConfigHandler.MINING_CHARM_BREAK_BOOST.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm5");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharmNightVision", mode.func_150254_d());
    }

    public void removeNightVisionEffect(PlayerEntity player, int duration) {
        EffectInstance effect;
        if (player.func_70660_b(Effects.field_76439_r) != null && (effect = player.func_70660_b(Effects.field_76439_r)).func_76459_b() == duration - 1) {
            player.func_195063_d(Effects.field_76439_r);
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && SuperpositionHandler.hasCurio(living, EnigmaticLegacy.miningCharm)) {
            PlayerEntity player = (PlayerEntity)living;
            ItemStack stack = SuperpositionHandler.getCurioStack((LivingEntity)player, EnigmaticLegacy.miningCharm);
            if (ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true) && player.func_226278_cu_() < 50.0 && player.field_71093_bK.func_186068_a() != -1 && player.field_71093_bK.func_186068_a() != 1 && !player.func_213290_a(FluidTags.field_206959_a, true) && !player.field_70170_p.func_175710_j(player.func_180425_c()) && player.field_70170_p.func_205049_d(player.func_180425_c(), 0) <= 8) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, this.nightVisionDuration, 0, true, false));
            } else {
                this.removeNightVisionEffect(player, this.nightVisionDuration);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", false);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHOFF, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", true);
            world.func_184133_a(null, player.func_180425_c(), EnigmaticLegacy.HHON, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        player.func_184609_a(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void onUnequipped(String identifier, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            this.removeNightVisionEffect((PlayerEntity)living, this.nightVisionDuration);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
        HashMultimap atts = HashMultimap.create();
        if (ConfigHandler.MINING_CHARM_BONUS_LUCK.getValue()) {
            atts.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("03c3c89d-7037-4b42-880f-b146bcb64d2e"), "Fortune bonus", 1.0, AttributeModifier.Operation.ADDITION));
        }
        atts.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("08c3c83d-7137-4b42-880f-b146bcb64d2e"), "Reach bonus", ConfigHandler.MINING_CHARM_REACH_BOOST.getValue(), AttributeModifier.Operation.ADDITION));
        return atts;
    }
}

