/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.ArrayListMultimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class OblivionStone
extends ItemBase {
    public OblivionStone() {
        super(ItemBase.getDefaultProperties().func_200917_a(1).func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "oblivion_stone"));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.OBLIVION_STONE_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone2_more");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone12");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone13");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone14");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStone15");
        } else if (Screen.hasControlDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStoneCtrlList");
            if (stack.func_77942_o()) {
                CompoundNBT nbt = stack.func_77978_p();
                ListNBT arr = nbt.func_150295_c("SupersolidID", 8);
                int counter = 0;
                if (arr.size() <= ConfigHandler.OBLIVION_STONE_SOFTCAP.getValue()) {
                    for (INBT s_uncast : arr) {
                        String s = ((StringNBT)s_uncast).func_150285_a_();
                        Item something = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                        if (something != null) {
                            ItemStack displayStack = new ItemStack((IItemProvider)something, 1);
                            list.add(new StringTextComponent(" - " + displayStack.func_200301_q().func_150261_e()).func_211709_a(new TextFormatting[]{TextFormatting.GOLD}));
                        }
                        ++counter;
                    }
                } else {
                    for (int s = 0; s < ConfigHandler.OBLIVION_STONE_SOFTCAP.getValue(); ++s) {
                        int randomID = Item.field_77697_d.nextInt(arr.size());
                        Item something = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(((StringNBT)arr.get(randomID)).func_150285_a_()));
                        if (something == null) continue;
                        ItemStack displayStack = new ItemStack((IItemProvider)something, 1);
                        list.add(new StringTextComponent(" - " + displayStack.func_200301_q().func_150261_e()).func_211709_a(new TextFormatting[]{TextFormatting.GOLD}));
                    }
                }
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStoneHoldCtrl");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        TranslationTextComponent mode = ItemNBTHelper.getBoolean(stack, "IsActive", true) ? new TranslationTextComponent("tooltip.enigmaticlegacy.oblivionStoneMode" + ItemNBTHelper.getInt(stack, "ConsumptionMode", 0), new Object[0]) : new TranslationTextComponent("tooltip.enigmaticlegacy.oblivionStoneModeInactive", new Object[0]);
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oblivionStoneModeDesc", mode);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int mode = ItemNBTHelper.getInt(stack, "ConsumptionMode", 0);
        if (player.func_225608_bj_()) {
            world.func_184133_a(null, player.func_180425_c(), ItemNBTHelper.getBoolean(stack, "IsActive", true) ? EnigmaticLegacy.HHOFF : EnigmaticLegacy.HHON, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
            ItemNBTHelper.setBoolean(stack, "IsActive", !ItemNBTHelper.getBoolean(stack, "IsActive", true));
        } else {
            if (mode >= 0 && mode < 2) {
                ItemNBTHelper.setInt(stack, "ConsumptionMode", mode + 1);
            } else {
                ItemNBTHelper.setInt(stack, "ConsumptionMode", 0);
            }
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        player.func_184609_a(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof PlayerEntity) || entity.field_70173_aa % 4 != 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (!ItemNBTHelper.getBoolean(stack, "IsActive", true) || stack.func_196082_o().func_150295_c("SupersolidID", 8).size() < 1) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        ListNBT arr = nbt.func_150295_c("SupersolidID", 8);
        OblivionStone.consumeStuff(player, arr, ItemNBTHelper.getInt(stack, "ConsumptionMode", 0));
    }

    public static void consumeStuff(PlayerEntity player, ListNBT list, int mode) {
        block13: {
            int filledStacks;
            int cycleCounter;
            HashMap<Integer, Object> stackMap;
            block14: {
                block12: {
                    stackMap = new HashMap<Integer, Object>();
                    cycleCounter = 0;
                    filledStacks = 0;
                    for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
                        if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b()) continue;
                        ++filledStacks;
                        if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() == EnigmaticLegacy.oblivionStone) continue;
                        stackMap.put(slot, player.field_71071_by.field_70462_a.get(slot));
                    }
                    if (stackMap.size() == 0) {
                        return;
                    }
                    if (mode != 0) break block12;
                    for (INBT sID : list) {
                        String str = ((StringNBT)sID).func_150285_a_();
                        Iterator iterator = stackMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            int slot = (Integer)iterator.next();
                            if (((ItemStack)stackMap.get(slot)).func_77973_b() != ForgeRegistries.ITEMS.getValue(new ResourceLocation(str))) continue;
                            player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                        }
                        ++cycleCounter;
                    }
                    break block13;
                }
                if (mode != 1) break block14;
                for (INBT sID : list) {
                    int slot;
                    String str = ((StringNBT)sID).func_150285_a_();
                    HashMap localStackMap = new HashMap(stackMap);
                    ArrayListMultimap stackSizeMultimap = ArrayListMultimap.create();
                    Iterator iterator = stackMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        slot = (Integer)iterator.next();
                        if (((ItemStack)stackMap.get(slot)).func_77973_b() == ForgeRegistries.ITEMS.getValue(new ResourceLocation(str))) continue;
                        localStackMap.remove(slot);
                    }
                    iterator = localStackMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        slot = (Integer)iterator.next();
                        stackSizeMultimap.put((Object)((ItemStack)localStackMap.get(slot)).func_190916_E(), (Object)slot);
                    }
                    while (localStackMap.size() > (((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b() == ForgeRegistries.ITEMS.getValue(new ResourceLocation(str)) ? 0 : 1)) {
                        int smallestStackSize = (Integer)Collections.min(stackSizeMultimap.keySet());
                        Collection smallestStacks = stackSizeMultimap.get((Object)smallestStackSize);
                        int slotWithSmallestStack = (Integer)Collections.max(smallestStacks);
                        player.field_71071_by.func_70299_a(slotWithSmallestStack, ItemStack.field_190927_a);
                        stackSizeMultimap.remove((Object)smallestStackSize, (Object)slotWithSmallestStack);
                        localStackMap.remove(slotWithSmallestStack);
                    }
                    ++cycleCounter;
                }
                break block13;
            }
            if (mode != 2 || filledStacks < player.field_71071_by.field_70462_a.size()) break block13;
            for (INBT sID : list) {
                int slot;
                String str = ((StringNBT)sID).func_150285_a_();
                HashMap localStackMap = new HashMap(stackMap);
                ArrayListMultimap stackSizeMultimap = ArrayListMultimap.create();
                Iterator smallestStackSize = stackMap.keySet().iterator();
                while (smallestStackSize.hasNext()) {
                    slot = (Integer)smallestStackSize.next();
                    if (((ItemStack)stackMap.get(slot)).func_77973_b() == ForgeRegistries.ITEMS.getValue(new ResourceLocation(str))) continue;
                    localStackMap.remove(slot);
                }
                smallestStackSize = localStackMap.keySet().iterator();
                while (smallestStackSize.hasNext()) {
                    slot = (Integer)smallestStackSize.next();
                    stackSizeMultimap.put((Object)((ItemStack)localStackMap.get(slot)).func_190916_E(), (Object)slot);
                }
                if (localStackMap.size() > 0) {
                    int smallestStackSize2 = (Integer)Collections.min(stackSizeMultimap.keySet());
                    Collection smallestStacks = stackSizeMultimap.get((Object)smallestStackSize2);
                    int slotWithSmallestStack = (Integer)Collections.max(smallestStacks);
                    player.field_71071_by.func_70299_a(slotWithSmallestStack, ItemStack.field_190927_a);
                    return;
                }
                ++cycleCounter;
            }
        }
    }
}

