/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.MagnetRing;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class SuperMagnetRing
extends MagnetRing {
    public SuperMagnetRing() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "super_magnet_ring"));
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.SUPER_MAGNET_RING_ENABLED.getValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.superMagnetRing1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.superMagnetRing2", ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue());
            ItemLoreHelper.addLocalizedString(list, ConfigHandler.INVERT_MAGNETS_SHIFT.getValue() ? "tooltip.enigmaticlegacy.superMagnetRing3_alt" : "tooltip.enigmaticlegacy.superMagnetRing3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (ConfigHandler.INVERT_MAGNETS_SHIFT.getValue() ? !living.func_225608_bj_() : living.func_225608_bj_() || living.field_70170_p.field_72995_K || !(living instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        double x = living.func_226277_ct_();
        double y = living.func_226278_cu_() + 0.75;
        double z = living.func_226281_cx_();
        List items = living.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue(), y - (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue(), z - (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue(), x + (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue(), y + (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue(), z + (double)ConfigHandler.SUPER_MAGNET_RING_RANGE.getValue()));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (!this.canPullItem(item)) continue;
            if (pulled > 512) break;
            if (!SuperpositionHandler.canPickStack(player, item.func_92059_d())) continue;
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), 24.0, item.field_71093_bK)), (Object)new PacketPortalParticles(item.func_226277_ct_(), item.func_226278_cu_() + (double)(item.func_213302_cg() / 2.0f), item.func_226281_cx_(), 24, 0.75, true));
            if (ConfigHandler.SUPER_MAGNET_RING_SOUND.getValue()) {
                item.field_70170_p.func_184133_a(null, item.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            }
            item.func_174868_q();
            item.func_70100_b_(player);
            ++pulled;
        }
    }

    @Override
    protected boolean canPullItem(ItemEntity item) {
        return super.canPullItem(item);
    }
}

