/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IAdvancedPotionItem;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.entities.EnigmaticPotionEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.PotionHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import com.integral.enigmaticlegacy.objects.AdvancedPotion;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UltimatePotionLingering
extends ItemBase
implements IAdvancedPotionItem {
    public IAdvancedPotionItem.PotionType potionType;

    public UltimatePotionLingering(Rarity rarity, IAdvancedPotionItem.PotionType type) {
        super(ItemBase.getDefaultProperties().func_208103_a(rarity).func_200917_a(1).func_200916_a(EnigmaticLegacy.enigmaticPotionTab));
        this.potionType = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        ItemStack stack = super.func_190903_i().func_77946_l();
        PotionHelper.setAdvancedPotion(stack, EnigmaticLegacy.EMPTY);
        return stack.func_77946_l();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + ".effect." + PotionHelper.getAdvancedPotion(stack).getId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isForMortals() {
        return this.potionType == IAdvancedPotionItem.PotionType.COMMON ? ConfigHandler.COMMON_POTIONS_ENABLED.getValue() : ConfigHandler.ULTIMATE_POTIONS_ENABLED.getValueDefault();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        SuperpositionHandler.addPotionTooltip(PotionHelper.getEffects(stack), stack, list, 0.25f);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        block4: {
            if (!this.func_194125_a(group)) break block4;
            if (this.potionType == IAdvancedPotionItem.PotionType.COMMON) {
                for (AdvancedPotion potion : EnigmaticLegacy.commonPotionTypes) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    ItemNBTHelper.setString(stack, "EnigmaticPotion", potion.getId());
                    items.add((Object)stack);
                }
            } else {
                for (AdvancedPotion potion : EnigmaticLegacy.ultimatePotionTypes) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    ItemNBTHelper.setString(stack, "EnigmaticPotion", potion.getId());
                    items.add((Object)stack);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ItemStack throwed = playerIn.field_71075_bZ.field_75098_d ? itemstack.func_77946_l() : itemstack.func_77979_a(1);
        worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187756_df, SoundCategory.PLAYERS, 0.5f, 0.4f / (Item.field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EnigmaticPotionEntity potionEntity = new EnigmaticPotionEntity(worldIn, (LivingEntity)playerIn);
            potionEntity.setItem(throwed);
            potionEntity.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, -20.0f, 0.5f, 1.0f);
            worldIn.func_217376_c((Entity)potionEntity);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @Override
    public IAdvancedPotionItem.PotionType getPotionType() {
        return this.potionType;
    }
}

