/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.ConfigHandler;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ObfuscatedFields;
import com.integral.enigmaticlegacy.items.generic.ItemAdvancedCurio;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoidPearl
extends ItemAdvancedCurio
implements ISpellstone {
    public List<String> healList = new ArrayList<String>();
    public DamageSource theDarkness;

    public VoidPearl() {
        super(ItemAdvancedCurio.getDefaultProperties().func_200917_a(1).func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "void_pearl"));
        this.immunityList.add(DamageSource.field_76369_e.field_76373_n);
        this.immunityList.add(DamageSource.field_76368_d.field_76373_n);
        this.healList.add(DamageSource.field_82727_n.field_76373_n);
        this.healList.add(DamageSource.field_76376_m.field_76373_n);
        this.theDarkness = new DamageSource("darkness");
        this.theDarkness.func_151518_m();
        this.theDarkness.func_76348_h();
        this.theDarkness.func_82726_p();
    }

    @Override
    public boolean isForMortals() {
        return ConfigHandler.VOID_PEARL_ENABLED.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.hasShiftDown()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearlCooldown", Float.valueOf((float)ConfigHandler.VOID_PEARL_COOLDOWN.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl12", ConfigHandler.VOID_PEARL_UNDEAD_PROBABILITY.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl13");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", ((String)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void onCurioTick(String identifier, int index, LivingEntity living) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            FoodStats stats = player.func_71024_bL();
            stats.func_75114_a(20);
            try {
                ObfuscatedFields.foodSaturationField.setFloat(stats, 0.0f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (player.func_70086_ai() < 300) {
                player.func_70050_g(300);
            }
            if (player.field_70173_aa % 10 == 0) {
                List entities = living.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(player.func_226277_ct_() - ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue(), player.func_226278_cu_() - ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue(), player.func_226281_cx_() - ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue(), player.func_226277_ct_() + ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue(), player.func_226278_cu_() + ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue(), player.func_226281_cx_() + ConfigHandler.VOID_PEARL_SHADOW_RANGE.getValue()));
                if (entities.contains(player)) {
                    entities.remove(player);
                }
                for (LivingEntity victim : entities) {
                    PlayerEntity playerVictim;
                    if (victim.field_70170_p.func_205049_d(victim.func_180425_c(), 0) >= 3) continue;
                    if (victim instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(playerVictim = (PlayerEntity)victim), EnigmaticLegacy.voidPearl)) {
                        playerVictim.func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 1, false, true));
                        continue;
                    }
                    victim.func_70097_a(this.theDarkness, (float)ConfigHandler.VOID_PEARL_BASE_DARKNESS_DAMAGE.getValue());
                    living.field_70170_p.func_184133_a(null, victim.func_180425_c(), SoundEvents.field_203257_fu, SoundCategory.PLAYERS, 1.0f, (float)((double)0.3f + Math.random() * 0.4));
                    victim.func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 1, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76438_s, 160, 2, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 3, false, true));
                }
            }
        }
    }
}

