/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items.generic;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IPerhaps;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.ToolItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;

public abstract class ItemBaseTool
extends ToolItem
implements IPerhaps {
    public Set<Material> effectiveMaterials = Sets.newHashSet();
    public ItemStack defaultInstance = new ItemStack((IItemProvider)this);

    public ItemBaseTool(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, effectiveBlocksIn, builder);
    }

    public ItemBaseTool(IItemTier tier) {
        this(4.0f, -2.8f, tier, new HashSet<Block>(), ItemBaseTool.getDefaultProperties().addToolType(ToolType.PICKAXE, tier.func_200925_d()));
    }

    public ItemBaseTool() {
        this(4.0f, -2.8f, EnigmaticMaterials.ETHERIUM, new HashSet<Block>(), ItemBaseTool.getDefaultProperties().addToolType(ToolType.PICKAXE, EnigmaticMaterials.ETHERIUM.func_200925_d()));
    }

    @Override
    public boolean isForMortals() {
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        if (this.getToolTypes(this.defaultInstance).contains(blockIn.getHarvestTool())) {
            if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
                return i >= blockIn.getHarvestLevel();
            }
            return true;
        }
        Material material = blockIn.func_185904_a();
        return this.effectiveMaterials.contains(material);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public static Item.Properties getDefaultProperties() {
        Item.Properties props = new Item.Properties();
        props.func_200916_a(EnigmaticLegacy.enigmaticTab);
        props.func_200917_a(1);
        props.func_208103_a(Rarity.COMMON);
        return props;
    }
}

