/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.packets.server;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.items.AngelBlessing;
import com.integral.enigmaticlegacy.items.EnigmaticItem;
import com.integral.enigmaticlegacy.items.EyeOfNebula;
import com.integral.enigmaticlegacy.items.GolemHeart;
import com.integral.enigmaticlegacy.items.MagmaHeart;
import com.integral.enigmaticlegacy.items.OceanStone;
import com.integral.enigmaticlegacy.items.VoidPearl;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSpellstoneKey {
    private boolean pressed;
    private int spellstoneID;

    public PacketSpellstoneKey(boolean pressed, int spellstoneID) {
        this.pressed = pressed;
        this.spellstoneID = spellstoneID;
    }

    public static void encode(PacketSpellstoneKey msg, PacketBuffer buf) {
        buf.writeBoolean(msg.pressed);
        buf.writeInt(msg.spellstoneID);
    }

    public static PacketSpellstoneKey decode(PacketBuffer buf) {
        return new PacketSpellstoneKey(buf.readBoolean(), buf.readInt());
    }

    public static void handle(PacketSpellstoneKey msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity playerServ = ((NetworkEvent.Context)ctx.get()).getSender();
            switch (msg.spellstoneID) {
                default: {
                    EnigmaticLegacy.enigmaticLogger.error("Invalid spellstone ID received by spellstone active ability handler");
                    break;
                }
                case 0: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.voidPearl)) break;
                    VoidPearl spellstoneVoidPearl = EnigmaticLegacy.voidPearl;
                    spellstoneVoidPearl.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.voidPearl));
                    break;
                }
                case 1: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.angelBlessing)) break;
                    AngelBlessing spellstoneAngelBlessing = EnigmaticLegacy.angelBlessing;
                    spellstoneAngelBlessing.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.angelBlessing));
                    break;
                }
                case 2: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.oceanStone)) break;
                    OceanStone spellstoneOceanStone = EnigmaticLegacy.oceanStone;
                    spellstoneOceanStone.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.oceanStone));
                    break;
                }
                case 3: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.magmaHeart)) break;
                    MagmaHeart spellstoneMagmaHeart = EnigmaticLegacy.magmaHeart;
                    spellstoneMagmaHeart.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.magmaHeart));
                    break;
                }
                case 4: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.golemHeart)) break;
                    GolemHeart spellstoneGolemHeart = EnigmaticLegacy.golemHeart;
                    spellstoneGolemHeart.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.golemHeart));
                    break;
                }
                case 5: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.eyeOfNebula)) break;
                    EyeOfNebula spellstoneEyeOfNebula = EnigmaticLegacy.eyeOfNebula;
                    spellstoneEyeOfNebula.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.eyeOfNebula));
                    break;
                }
                case 6: {
                    if (!SuperpositionHandler.hasCurio((LivingEntity)playerServ, EnigmaticLegacy.enigmaticItem)) break;
                    EnigmaticItem spellstoneEnigmaticItem = EnigmaticLegacy.enigmaticItem;
                    spellstoneEnigmaticItem.triggerActiveAbility(playerServ.field_70170_p, playerServ, SuperpositionHandler.getCurioStack((LivingEntity)playerServ, EnigmaticLegacy.enigmaticItem));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

