/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat;

import com.userofbricks.expandedcombat.client.renderer.entity.ECArrowEntityRenderer;
import com.userofbricks.expandedcombat.client.renderer.model.SpecialItemModels;
import com.userofbricks.expandedcombat.curios.ArrowCurio;
import com.userofbricks.expandedcombat.enchentments.ECEnchantments;
import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import com.userofbricks.expandedcombat.entity.ECEntities;
import com.userofbricks.expandedcombat.item.ECItemGroup;
import com.userofbricks.expandedcombat.item.ECItemModelsProperties;
import com.userofbricks.expandedcombat.item.ECItems;
import com.userofbricks.expandedcombat.item.GauntletItem;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import com.userofbricks.expandedcombat.util.NetworkHandler;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.gui.CuriosScreen;

@Mod(value="expanded_combat")
public class ExpandedCombat {
    public static final String MODID = "expanded_combat";
    public static final ITag<Item> arrow_curios = ItemTags.func_199901_a((String)new ResourceLocation("curios", "arrows").toString());
    public static final Predicate<ItemStack> arrow_predicate = stack -> stack.func_77973_b().func_206844_a(arrow_curios);
    public static final ITag<Item> hands_curios = ItemTags.func_199901_a((String)new ResourceLocation("curios", "hands").toString());
    public static final Predicate<ItemStack> hands_predicate = stack -> stack.func_77973_b().func_206844_a(hands_curios);
    public static final ItemGroup EC_GROUP = new ECItemGroup();

    public ExpandedCombat() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        AttributeRegistry.ATTRIBUTES.register(bus);
        ECEnchantments.ENCHANTMENTS.register(bus);
        ECItems.ITEMS.register(bus);
        RecipeSerializerInit.RECIPE_SERIALIZERS.register(bus);
        ECEntities.ENTITIES.register(bus);
        bus.addListener(this::comms);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCaps);
        MinecraftForge.EVENT_BUS.addListener(this::DamageGauntletEvent);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::drawSlotBack);
            bus.addListener(this::stitchTextures);
            bus.addListener(this::onModelBake);
            bus.addListener(this::itemColors);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void DamageGauntletEvent(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        Optional optionalImmutableTriple = CuriosApi.getCuriosHelper().findEquippedCurio(hands_predicate, (LivingEntity)player);
        ItemStack stack = optionalImmutableTriple.map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a);
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCurioItemHandler -> {
            if (!player.func_184812_l_() && stack.func_77973_b() instanceof GauntletItem && optionalImmutableTriple.isPresent()) {
                stack.func_222118_a(1, (LivingEntity)player, damager -> CuriosApi.getCuriosHelper().onBrokenCurio((String)((ImmutableTriple)optionalImmutableTriple.get()).getLeft(), ((Integer)((ImmutableTriple)optionalImmutableTriple.get()).getMiddle()).intValue(), damager));
            }
        });
    }

    private void comms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("quiver").icon(new ResourceLocation(MODID, "item/empty_quiver_slot")).hide().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("arrows").icon(new ResourceLocation(MODID, "item/empty_arrows_slot")).hide().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("hands").build());
    }

    private void drawSlotBack(GuiContainerEvent.DrawBackground e) {
        if (e.getGuiContainer() instanceof CuriosScreen) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            CuriosScreen curiosScreen = (CuriosScreen)e.getGuiContainer();
            int i = curiosScreen.getGuiLeft();
            int j = curiosScreen.getGuiTop();
            curiosScreen.func_238474_b_(e.getMatrixStack(), i + 77, j + 19, 7, 7, 18, 36);
        }
    }

    public void stitchTextures(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            String[] array = new String[]{"arrows", "quiver"};
            String[] icons = array;
            for (String icon : array) {
                event.addSprite(new ResourceLocation(MODID, "item/empty_" + icon + "_slot"));
            }
        }
    }

    public void itemColors(ColorHandlerEvent.Item event) {
        ItemColors itemcolors = event.getItemColors();
        itemcolors.func_199877_a((itemStack, itemLayer) -> itemLayer == 1 ? PotionUtils.func_190932_c((ItemStack)itemStack) : -1, new IItemProvider[]{(IItemProvider)ECItems.IRON_TIPPED_ARROW.get(), (IItemProvider)ECItems.DIAMOND_TIPPED_ARROW.get(), (IItemProvider)ECItems.NETHERITE_TIPPED_ARROW.get()});
        itemcolors.func_199877_a((stack, color) -> color > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{(IItemProvider)ECItems.BATTLESTAFF_WOOD.get(), (IItemProvider)ECItems.BATTLESTAFF_DIAMOND.get(), (IItemProvider)ECItems.BATTLESTAFF_IRON.get(), (IItemProvider)ECItems.BATTLESTAFF_GOLD.get(), (IItemProvider)ECItems.BATTLESTAFF_STONE.get(), (IItemProvider)ECItems.BATTLESTAFF_NETHERITE.get(), (IItemProvider)ECItems.BROADSWORD_WOOD.get(), (IItemProvider)ECItems.BROADSWORD_DIAMOND.get(), (IItemProvider)ECItems.BROADSWORD_IRON.get(), (IItemProvider)ECItems.BROADSWORD_GOLD.get(), (IItemProvider)ECItems.BROADSWORD_STONE.get(), (IItemProvider)ECItems.BROADSWORD_NETHERITE.get(), (IItemProvider)ECItems.CLAYMORE_WOOD.get(), (IItemProvider)ECItems.CLAYMORE_DIAMOND.get(), (IItemProvider)ECItems.CLAYMORE_IRON.get(), (IItemProvider)ECItems.CLAYMORE_GOLD.get(), (IItemProvider)ECItems.CLAYMORE_STONE.get(), (IItemProvider)ECItems.CLAYMORE_NETHERITE.get(), (IItemProvider)ECItems.DANCERS_SWORD_WOOD.get(), (IItemProvider)ECItems.DANCERS_SWORD_DIAMOND.get(), (IItemProvider)ECItems.DANCERS_SWORD_IRON.get(), (IItemProvider)ECItems.DANCERS_SWORD_GOLD.get(), (IItemProvider)ECItems.DANCERS_SWORD_STONE.get(), (IItemProvider)ECItems.DANCERS_SWORD_NETHERITE.get(), (IItemProvider)ECItems.GLAIVE_WOOD.get(), (IItemProvider)ECItems.GLAIVE_DIAMOND.get(), (IItemProvider)ECItems.GLAIVE_IRON.get(), (IItemProvider)ECItems.GLAIVE_GOLD.get(), (IItemProvider)ECItems.GLAIVE_STONE.get(), (IItemProvider)ECItems.GLAIVE_NETHERITE.get()});
        itemcolors.func_199877_a((stack, color) -> color > 0 ? -1 : PotionUtils.func_190932_c((ItemStack)stack), new IItemProvider[]{(IItemProvider)ECItems.SCYTHE_STONE.get(), (IItemProvider)ECItems.SCYTHE_DIAMOND.get(), (IItemProvider)ECItems.SCYTHE_GOLD.get(), (IItemProvider)ECItems.SCYTHE_IRON.get(), (IItemProvider)ECItems.SCYTHE_WOOD.get(), (IItemProvider)ECItems.SCYTHE_NETHERITE.get()});
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> e) {
        ItemStack stack = (ItemStack)e.getObject();
        if (ItemTags.func_199903_a().func_199910_a(new ResourceLocation("curios", "arrows")) != null && arrow_curios.func_230235_a_((Object)stack.func_77973_b())) {
            final ArrowCurio arrowCurio = new ArrowCurio();
            e.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> arrowCurio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(NetworkHandler::init);
        ECItems.setAtributeModifiers();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ECItemModelsProperties());
        SpecialItemModels.detectSpecials();
        this.registerEtityModels(event.getMinecraftSupplier());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerEtityModels(Supplier<Minecraft> minecraft) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ECEntities.EC_ARROW_ENTITY.get()), ECArrowEntityRenderer::new);
    }

    public void onModelBake(ModelBakeEvent event) {
        SpecialItemModels.onModelBake(event);
    }

    public static boolean modResourceExists(ResourcePackType type, ResourceLocation res) {
        ModFileResourcePack ecAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)MODID).get();
        return ecAsPack.func_195764_b(type, res);
    }
}

