/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ECBowItem
extends BowItem {
    private int multishotLevel;
    private int bowPower;
    private final float velocityMultiplyer;
    float mendingBonus;

    public ECBowItem(float mendingBonus, float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECBowItem(float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = 0.0f;
    }

    public ECBowItem(float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public ECBowItem(float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public int getMultishotLevel() {
        return this.multishotLevel;
    }

    private int getBowPower() {
        return this.bowPower;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)entityLiving;
            boolean useInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.func_213356_f(stack);
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)playerentity, (int)charge, (!itemstack.func_190926_b() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || useInfiniteAmmo) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float arrowVelocity = this.getBowArrowVelocity(stack, charge);
                this.fireArrows(stack, worldIn, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    public void fireArrows(ItemStack stack, World worldIn, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack) + this.getMultishotLevel();
        int arrowsToFire = 1 + multishotLevel * 2;
        for (int arrowNumber = 0; arrowNumber < arrowsToFire; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!worldIn.field_72995_K) {
                this.createBowArrow(stack, worldIn, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d || isAdditionalShot)) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerentity.field_71071_by.func_184437_d(itemstack);
                }
            }
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    public void createBowArrow(ItemStack stack, World worldIn, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        int k;
        int powerLevel;
        ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, itemstack, (LivingEntity)playerentity);
        abstractarrowentity = this.customArrow(abstractarrowentity);
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractarrowentity);
        if (arrowVelocity == 1.0f) {
            abstractarrowentity.func_70243_d(true);
        }
        if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack) + this.getBowPower()) > 0) {
            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
            abstractarrowentity.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            abstractarrowentity.func_70015_d(100);
        }
        stack.func_222118_a(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
        if (hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        worldIn.func_217376_c((Entity)abstractarrowentity);
    }

    public void setArrowTrajectory(PlayerEntity playerentity, float arrowVelocity, int i, AbstractArrowEntity abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 0.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 10.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 10.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 20.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 20.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 30.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 30.0f, 0.0f, arrowVelocity * this.velocityMultiplyer, 1.0f);
        }
    }

    public float getBowArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = this.getBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public float getBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return Math.max(20 - 5 * quickChargeLevel, 0);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.mendingBonus;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.mendingBonus != 0.0f) {
            if (this.mendingBonus > 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mending Bonus +" + ItemStack.field_111284_a.format(this.mendingBonus)));
            } else if (this.mendingBonus < 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Mending Bonus " + ItemStack.field_111284_a.format(this.mendingBonus)));
            }
        }
    }
}

