/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ECCrossBowItem
extends CrossbowItem {
    private int multishotLevel;
    private int bowPower;
    private final float velocityMultiplyer;
    float mendingBonus;
    public boolean field_220034_c = false;
    public boolean field_220035_d = false;

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float mendingBonus, float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = mendingBonus;
    }

    public ECCrossBowItem(float velocityMultiplyer, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = 0;
        this.mendingBonus = 0.0f;
    }

    public ECCrossBowItem(float velocityMultiplyer, int bowPower, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = 0;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public ECCrossBowItem(float velocityMultiplyer, int bowPower, int multishotLevel, Item.Properties builder) {
        super(builder);
        this.velocityMultiplyer = velocityMultiplyer;
        this.multishotLevel = multishotLevel;
        this.bowPower = bowPower;
        this.mendingBonus = 0.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ECCrossBowItem.func_220012_d((ItemStack)itemstack)) {
            this.fireCrossbowProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, this.getProjectileVelocity(itemstack), 1.0f);
            CrossbowItem.func_220011_a((ItemStack)itemstack, (boolean)false);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            if (!ECCrossBowItem.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                playerIn.func_184598_c(handIn);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.field_72995_K) {
            int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent quickChargeSoundEvent = this.getCrossbowSoundEvent(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.field_219611_bC : null;
            float chargeTime = (float)(stack.func_77988_m() - timeLeft) / (float)this.getCrossbowChargeTime(stack);
            if (chargeTime < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (chargeTime >= 0.2f && !this.field_220034_c && chargeTime < 1.0f) {
                this.field_220034_c = true;
                world.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), quickChargeSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !this.field_220035_d && chargeTime < 1.0f) {
                this.field_220035_d = true;
                world.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), loadingMiddleSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = this.getCrossbowCharge(i, stack);
        if (f >= 1.0f && !ECCrossBowItem.func_220012_d((ItemStack)stack) && this.func_220021_a(entityLiving, stack)) {
            ECCrossBowItem.func_220011_a((ItemStack)stack, (boolean)true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a(null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)this.getCrossbowChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getCrossbowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return Math.max(25 - 5 * quickChargeLevel, 0);
    }

    public SoundEvent getCrossbowSoundEvent(int i) {
        switch (i) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    public void fireCrossbowProjectiles(World world, LivingEntity livingEntity, Hand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = ECCrossBowItem.getChargedProjectiles(stack);
        float[] randomSoundPitches = ECCrossBowItem.getRandomSoundPitches(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 2) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 3) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i == 4) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
                continue;
            }
            if (i == 5) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -30.0f);
                continue;
            }
            if (i != 6) continue;
            this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 30.0f);
        }
        ECCrossBowItem.fireProjectilesAfter(world, livingEntity, stack);
    }

    private AbstractArrowEntity createCrossbowArrow(World world, LivingEntity livingEntity, ItemStack stack, ItemStack stack1) {
        int punchLevel;
        int powerLevel;
        ArrowItem arrowItem = (ArrowItem)(stack1.func_77973_b() instanceof ArrowItem ? stack1.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowItem.func_200887_a(world, stack1, livingEntity);
        if (livingEntity instanceof PlayerEntity) {
            abstractArrowEntity.func_70243_d(true);
        }
        abstractArrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        abstractArrowEntity.func_213865_o(true);
        int piercingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)stack);
        if (piercingLevel > 0) {
            abstractArrowEntity.func_213872_b((byte)piercingLevel);
        }
        if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack) + this.bowPower) > 0) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack) + this.bowPower) > 0) {
            abstractArrowEntity.func_70240_a(punchLevel);
        }
        return abstractArrowEntity;
    }

    public float getProjectileVelocity(ItemStack stack) {
        if (ECCrossBowItem.func_220019_a((ItemStack)stack, (Item)Items.field_196152_dE)) {
            return 1.6f * this.velocityMultiplyer;
        }
        return 3.2f * this.velocityMultiplyer;
    }

    public int func_77626_a(ItemStack stack) {
        return this.getCrossbowChargeTime(stack) + 3;
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    void func_220016_a(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity projectileentity;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                projectileentity = this.createCrossbowArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_230284_a_(Objects.requireNonNull(icrossbowuser.func_70638_az()), crossbow, (ProjectileEntity)projectileentity, projectileAngle);
            } else {
                Vector3d vector3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), projectileAngle, true);
                Vector3d vector3d2 = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vector3d2);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            crossbow.func_222118_a(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
            worldIn.func_217376_c((Entity)projectileentity);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    static void fireProjectilesAfter(World worldIn, LivingEntity shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
            if (!worldIn.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, stack);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
        ECCrossBowItem.clearProjectiles(stack);
    }

    private static void clearProjectiles(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt2 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt2));
            }
        }
        return list;
    }

    public static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, ECCrossBowItem.getRandomSoundPitch(flag), ECCrossBowItem.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    public boolean func_220021_a(LivingEntity entityIn, ItemStack stack) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack) + this.multishotLevel;
        int arrowsToFire = multishotLevel == 0 ? 1 : 1 + multishotLevel * 2;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack2 = itemstack.func_77946_l();
        for (int i = 0; i < arrowsToFire; ++i) {
            if (i > 0) {
                itemstack = itemstack2.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack2 = itemstack.func_77946_l();
            }
            if (ECCrossBowItem.canAddChargedProjectile(entityIn, stack, itemstack, i > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean canAddChargedProjectile(LivingEntity livingEntity, ItemStack stack, ItemStack stack1, boolean b, boolean b1) {
        ItemStack itemstack;
        boolean flag;
        if (stack1.func_190926_b()) {
            return false;
        }
        boolean bl = flag = b1 && stack1.func_77973_b() instanceof ArrowItem;
        if (!(flag || b1 || b)) {
            itemstack = stack1.func_77979_a(1);
            if (stack1.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(stack1);
            }
        } else {
            itemstack = stack1.func_77946_l();
        }
        ECCrossBowItem.addChargedProjectile(stack, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt2 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt2);
        listnbt.add((Object)compoundnbt2);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.mendingBonus;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.mendingBonus != 0.0f) {
            if (this.mendingBonus > 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mending Bonus +" + ItemStack.field_111284_a.format(this.mendingBonus)));
            } else if (this.mendingBonus < 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Mending Bonus " + ItemStack.field_111284_a.format(this.mendingBonus)));
            }
        }
    }
}

