/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import com.userofbricks.expandedcombat.item.IWeaponTier;
import com.userofbricks.expandedcombat.item.IWeaponType;
import com.userofbricks.expandedcombat.item.WeaponTypes;
import com.userofbricks.expandedcombat.util.CombatEventHandler;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ECWeaponItem
extends SwordItem {
    private final IWeaponTier weaponTier;
    private final IWeaponType type;
    private final float AttackDamage;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    protected static final UUID ATTACK_KNOCKBACK_MODIFIER = UUID.fromString("a3617883-03fa-4538-a821-7c0a506e8c56");
    protected static final UUID ATTACK_REACH_MODIFIER = UUID.fromString("bc644060-615a-4259-a648-5367cd0d45fa");

    public ECWeaponItem(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
        super(new IItemTier(){

            public int func_200926_a() {
                return 0;
            }

            public float func_200928_b() {
                return 0.0f;
            }

            public float func_200929_c() {
                return 0.0f;
            }

            public int func_200925_d() {
                return 0;
            }

            public int func_200927_e() {
                return 0;
            }

            public Ingredient func_200924_f() {
                return null;
            }
        }, 0, 0.0f, builderIn.func_200915_b(tierIn.getMaxUses()));
        this.weaponTier = tierIn;
        this.type = typeIn;
        this.AttackDamage = (float)this.type.getBaseAttackDamage() + this.weaponTier.getAttackDamage();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.AttackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.type.getBaseAttackSpead(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)this.type.getKnockback(), AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public static void setAtributeModifierMultimap(ECWeaponItem weaponItem) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)weaponItem.func_200894_d(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)weaponItem.getWeaponType().getBaseAttackSpead(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER, "Weapon modifier", (double)weaponItem.getWeaponType().getKnockback(), AttributeModifier.Operation.ADDITION));
        if (ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach"))) {
            builder.put((Object)Objects.requireNonNull(ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach"))), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", weaponItem.getAttackRange(), AttributeModifier.Operation.ADDITION));
        } else {
            builder.put((Object)AttributeRegistry.ATTACK_REACH.get(), (Object)new AttributeModifier(ATTACK_REACH_MODIFIER, "Weapon modifier", weaponItem.getAttackRange(), AttributeModifier.Operation.ADDITION));
        }
        weaponItem.attributeModifiers = builder.build();
    }

    public IWeaponTier getWeaponTier() {
        return this.weaponTier;
    }

    public IWeaponType getWeaponType() {
        return this.type;
    }

    public float func_200894_d() {
        return this.AttackDamage;
    }

    public double getAttackRange() {
        return this.getWeaponType().getBaseAttackRange();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlotType.MAINHAND || this.getWeaponType().getWieldingType() == WeaponTypes.WieldingType.DUALWIELD && equipmentSlot == EquipmentSlotType.OFFHAND ? this.attributeModifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public int func_77619_b() {
        return this.weaponTier.getEnchantability();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.weaponTier.getRepairMaterial().test(repair) || super.func_82789_a(toRepair, repair);
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 2.0f + this.type.getTypeMendingBonus() + this.weaponTier.getMendingBonus();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        float shieldMendingBonus = this.type.getTypeMendingBonus() + this.weaponTier.getMendingBonus();
        if (shieldMendingBonus != 0.0f) {
            if (shieldMendingBonus > 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Mending Bonus +" + ItemStack.field_111284_a.format(shieldMendingBonus)));
            } else if (shieldMendingBonus < 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Mending Bonus " + ItemStack.field_111284_a.format(shieldMendingBonus)));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.OFF_HAND && worldIn.field_72995_K) {
            CombatEventHandler.checkForOffhandAttack();
            ItemStack offhand = playerIn.func_184586_b(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)offhand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public static class HasPotionAndIsDyeable
    extends HasPotion
    implements IDyeableArmorItem {
        public HasPotionAndIsDyeable(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }
    }

    public static class HasPotion
    extends ECWeaponItem {
        public HasPotion(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }

        @Override
        public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
            if (PotionUtils.func_185191_c((ItemStack)stack) != Potions.field_185229_a) {
                for (EffectInstance effectInstance : PotionUtils.func_185191_c((ItemStack)stack).func_185170_a()) {
                    EffectInstance potionEffect = new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b() / 2);
                    target.func_195064_c(potionEffect);
                }
            }
            return super.func_77644_a(stack, target, attacker);
        }
    }

    public static class Dyeable
    extends ECWeaponItem
    implements IDyeableArmorItem {
        public Dyeable(IWeaponTier tierIn, IWeaponType typeIn, Item.Properties builderIn) {
            super(tierIn, typeIn, builderIn);
        }
    }
}

