/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.item.recipes;

import com.userofbricks.expandedcombat.item.ECWeaponItem;
import com.userofbricks.expandedcombat.item.recipes.RecipeSerializerInit;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ECScytheRecipe
extends SpecialRecipe {
    public ECScytheRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int numPotionWeapons = 0;
        int numPotions = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemStack = inv.func_70301_a(i);
            if (itemStack.func_77973_b() instanceof ECWeaponItem.HasPotion) {
                if (PotionUtils.func_185191_c((ItemStack)itemStack).func_185170_a().size() != 0) {
                    return false;
                }
                if (numPotionWeapons > 0) {
                    return false;
                }
                ++numPotionWeapons;
                continue;
            }
            if (!(itemStack.func_77973_b() instanceof PotionItem)) continue;
            if (numPotions > 0) {
                return false;
            }
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemStack);
            for (EffectInstance e : potion.func_185170_a()) {
                if (!e.func_188419_a().equals(Effects.field_76433_i)) continue;
                return false;
            }
            ++numPotions;
        }
        return numPotionWeapons == 1 && numPotions == 1;
    }

    public ItemStack assemble(CraftingInventory inv) {
        Potion potionEffect = null;
        ItemStack potionWeaponItem = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (item instanceof ECWeaponItem.HasPotion) {
                potionWeaponItem = stack;
                continue;
            }
            if (!(inv.func_70301_a(i).func_77973_b() instanceof PotionItem)) continue;
            potionEffect = PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(i));
        }
        if (potionEffect == null || potionWeaponItem == null) {
            return ItemStack.field_190927_a;
        }
        PotionUtils.func_185188_a(potionWeaponItem, potionEffect);
        return potionWeaponItem;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializerInit.EC_POTION_WEAPON_SERIALIZER.get();
    }
}

