/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.mixin;

import com.userofbricks.expandedcombat.mixin.ContainerAccessor;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;

@Mixin(value={CuriosContainer.class})
abstract class CurioContainerMixin
extends Container {
    @Shadow
    @Final
    private PlayerEntity player;
    @Shadow
    @Final
    LazyOptional<ICuriosItemHandler> curiosHandler;

    protected CurioContainerMixin(@Nullable ContainerType<?> type, int id) {
        super(type, id);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;)V"}, remap=false)
    private void init(int windowId, PlayerInventory playerInventory, CallbackInfo ci) {
        this.curiosHandler.ifPresent(iCuriosItemHandler -> {
            Map curioMap = iCuriosItemHandler.getCurios();
            for (String identifier : curioMap.keySet()) {
                IDynamicStackHandler iDynamicStackHandler;
                ICurioStacksHandler stackHandler;
                if (identifier.equals("quiver")) {
                    stackHandler = (ICurioStacksHandler)curioMap.get(identifier);
                    iDynamicStackHandler = stackHandler.getStacks();
                    ((ContainerAccessor)((Object)this)).$addSlot((Slot)new CurioSlot(this.player, iDynamicStackHandler, 0, identifier, 77, 20, stackHandler.getRenders()));
                }
                if (!identifier.equals("arrows")) continue;
                stackHandler = (ICurioStacksHandler)curioMap.get(identifier);
                iDynamicStackHandler = stackHandler.getStacks();
                ((ContainerAccessor)((Object)this)).$addSlot((Slot)new CurioSlot(this.player, iDynamicStackHandler, 0, identifier, 77, 38, stackHandler.getRenders()));
            }
        });
    }
}

