/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.mixin;

import com.userofbricks.expandedcombat.ExpandedCombat;
import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import java.util.Objects;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType_1, World world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"getProjectile"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkQuiver(ItemStack shootable, CallbackInfoReturnable<ItemStack> cir) {
        if (!(shootable.func_77973_b() instanceof ShootableItem)) {
            return;
        }
        ItemStack stack = CuriosApi.getCuriosHelper().findEquippedCurio(ExpandedCombat.arrow_predicate, (LivingEntity)this).map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            cir.setReturnValue((Object)stack);
        }
    }

    @ModifyConstant(method={"attack"}, constant={@Constant(doubleValue=9.0)})
    private double getAttackReachSquared(double value) {
        double attackReachValue = 3.0;
        attackReachValue = ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach")) ? this.func_233637_b_((Attribute)Objects.requireNonNull(ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach")))) : this.func_233637_b_((Attribute)AttributeRegistry.ATTACK_REACH.get());
        return attackReachValue * attackReachValue;
    }

    @Inject(method={"createAttributes"}, at={@At(value="RETURN")})
    private static void initAttributes(CallbackInfoReturnable<AttributeModifierMap.MutableAttribute> ci) {
        if (ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach"))) {
            ((AttributeModifierMap.MutableAttribute)ci.getReturnValue()).func_233814_a_((Attribute)Objects.requireNonNull(ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach"))));
        } else {
            ((AttributeModifierMap.MutableAttribute)ci.getReturnValue()).func_233814_a_((Attribute)AttributeRegistry.ATTACK_REACH.get());
        }
    }
}

