/*
 * Decompiled with CFR 0.152.
 */
package com.userofbricks.expandedcombat.util;

import com.userofbricks.expandedcombat.entity.AttributeRegistry;
import com.userofbricks.expandedcombat.item.ECWeaponItem;
import com.userofbricks.expandedcombat.item.WeaponTypes;
import com.userofbricks.expandedcombat.util.PlayerAttackHelper;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketOffhandAttack {
    private int entityID;

    public PacketOffhandAttack(int entityID) {
        this.entityID = entityID;
    }

    public static void encode(PacketOffhandAttack packet, PacketBuffer buf) {
        buf.writeInt(packet.entityID);
    }

    public static PacketOffhandAttack decode(PacketBuffer buf) {
        return new PacketOffhandAttack(buf.readInt());
    }

    public static class OffhandHandler {
        public static void handle(final PacketOffhandAttack packet, final Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ItemStack offhand;
                        ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                        Entity target = null;
                        if (player != null) {
                            target = player.field_70170_p.func_73045_a(packet.entityID);
                        }
                        if (target != null && !(offhand = player.func_184592_cb()).func_190926_b() && offhand.func_77973_b() instanceof ECWeaponItem && ((ECWeaponItem)offhand.func_77973_b()).getWeaponType().getWieldingType() == WeaponTypes.WieldingType.DUALWIELD) {
                            double distanceSquared;
                            float renderViewEntityOffsetFromPlayerMitigator;
                            double reachSquared;
                            float reach = ForgeRegistries.ATTRIBUTES.containsKey(new ResourceLocation("dungeons_gear:attack_reach")) ? (float)player.func_233637_b_(Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("dungeons_gear:attack_reach")))) : (float)player.func_233637_b_((Attribute)AttributeRegistry.ATTACK_REACH.get());
                            if (player.func_184812_l_()) {
                                reach = (float)((double)reach * 2.0);
                            }
                            if ((reachSquared = (double)((reach += (renderViewEntityOffsetFromPlayerMitigator = 0.2f)) * reach)) >= (distanceSquared = player.func_70068_e(target))) {
                                PlayerAttackHelper.attackTargetEntityWithCurrentOffhandItem(player, target);
                            }
                            PlayerAttackHelper.swingArm(player, Hand.OFF_HAND);
                        }
                    }
                });
            }
        }
    }
}

