/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems;

import com.mcmoddev.golems.ExtraGolems;
import com.mcmoddev.golems.block.GlowBlock;
import com.mcmoddev.golems.block.GolemHeadBlock;
import com.mcmoddev.golems.block.PowerBlock;
import com.mcmoddev.golems.container.GolemContainer;
import com.mcmoddev.golems.entity.GolemBase;
import com.mcmoddev.golems.item.GolemSpellItem;
import com.mcmoddev.golems.item.GuideBookItem;
import com.mcmoddev.golems.item.SpawnGolemItem;
import com.mcmoddev.golems.menu.PortableCraftingMenu;
import com.mcmoddev.golems.menu.PortableDispenserMenu;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="golems")
public final class EGRegistry {
    @ObjectHolder(value="golem_paper")
    public static final Item GOLEM_SPELL = null;
    @ObjectHolder(value="spawn_bedrock_golem")
    public static final Item SPAWN_BEDROCK_GOLEM = null;
    @ObjectHolder(value="info_book")
    public static final Item GOLEM_BOOK = null;
    @ObjectHolder(value="golem_head")
    public static final Block GOLEM_HEAD = null;
    @ObjectHolder(value="light_provider")
    public static final Block UTILITY_LIGHT = null;
    @ObjectHolder(value="power_provider")
    public static final Block UTILITY_POWER = null;
    @ObjectHolder(value="golem")
    public static final EntityType<GolemBase> GOLEM = null;
    @ObjectHolder(value="crafting_portable")
    public static final MenuType<PortableCraftingMenu> CRAFTING_GOLEM = new MenuType(PortableCraftingMenu::new);
    @ObjectHolder(value="dispenser_portable")
    public static final MenuType<PortableDispenserMenu> DISPENSER_GOLEM = new MenuType(PortableDispenserMenu::new);

    private EGRegistry() {
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ExtraGolems.LOGGER.info("golems:registerEntities");
        EntityType.Builder builder = EntityType.Builder.m_20704_(GolemBase::new, (MobCategory)MobCategory.MISC).setTrackingRange(48).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).m_20699_(1.4f, 2.9f).m_20698_();
        EntityType entityType = builder.m_20712_("golem");
        event.getRegistry().register((IForgeRegistryEntry)((EntityType)entityType.setRegistryName("golems", "golem")));
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        ExtraGolems.LOGGER.info("golems:registerEntityAttributes");
        event.put(GOLEM, GolemContainer.EMPTY.getAttributeSupplier().get().m_22265_());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ExtraGolems.LOGGER.info("golems:registerItems");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(GOLEM_HEAD, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)){

            @OnlyIn(value=Dist.CLIENT)
            public boolean m_5812_(ItemStack stack) {
                return true;
            }
        }.setRegistryName(GOLEM_HEAD.getRegistryName()), (Item)new SpawnGolemItem().setRegistryName("golems", "spawn_bedrock_golem"), (Item)new GolemSpellItem().setRegistryName("golems", "golem_paper"), (Item)new GuideBookItem().setRegistryName("golems", "info_book")});
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ExtraGolems.LOGGER.info("golems:registerBlocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new GolemHeadBlock().setRegistryName("golems", "golem_head"), (Block)new GlowBlock(Material.f_76275_, 1.0f).setRegistryName("golems", "light_provider"), (Block)new PowerBlock(15).setRegistryName("golems", "power_provider")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        ExtraGolems.LOGGER.info("golems:registerContainers");
        event.getRegistry().register((IForgeRegistryEntry)((MenuType)CRAFTING_GOLEM.setRegistryName("golems", "crafting_portable")));
        event.getRegistry().register((IForgeRegistryEntry)((MenuType)DISPENSER_GOLEM.setRegistryName("golems", "dispenser_portable")));
    }
}

