/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.block;

import com.mcmoddev.golems.block.UtilityBlock;
import com.mcmoddev.golems.entity.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class PowerBlock
extends UtilityBlock {
    public static final IntegerProperty POWER_LEVEL = IntegerProperty.m_61631_((String)"power", (int)0, (int)15);
    public static final int UPDATE_TICKS = 4;

    public PowerBlock(int powerLevel) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60977_(), 4);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER_LEVEL, (Comparable)Integer.valueOf(powerLevel)));
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        boolean hasPowerGolem;
        AABB toCheck = new AABB(pos).m_82400_(0.25);
        List list = worldIn.m_45976_(GolemBase.class, toCheck);
        boolean bl = hasPowerGolem = !list.isEmpty() && PowerBlock.hasPowerGolem(list);
        if (hasPowerGolem) {
            worldIn.m_6219_().m_5945_(pos, (Object)this, this.tickRate);
        } else {
            this.remove((Level)worldIn, state, pos, 3);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER_LEVEL});
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)POWER_LEVEL);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)POWER_LEVEL);
    }

    public static boolean hasPowerGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingPower()) continue;
            return true;
        }
        return false;
    }
}

